#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7


# Gibt alle übergebene Params aus, auch Named-Parameter

# 001, 250612, Tom


## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]
[CmdletBinding()]
Param(
    [Parameter(ValueFromRemainingArguments)]
    [Object[]]$Params
)

# Params prüfen, ob ein GetHelp gefragt ist
$HasGetHelp = @($Params | ? { $_ -like '-GetHelp*'}).Count -ge 1
$HasGetEx = @($Params | ? { $_ -like '-GetEx*'}).Count -ge 1
$HasRunEx = @($Params | ? { $_ -like '-RunEx*'}).Count -ge 1

# Write-Host "Params.Count: $($Params.Count)"
# Write-Host "Params[0]   : $($Params[0])"
# Write-Host "Params[1]   : $($Params[1])"
# Write-Host "Params[2]   : $($Params[2])"
# Write-Host "Params[3]   : $($Params[3])"
# Write-Host "HasGetEx    : $HasGetEx"

If ($HasGetHelp -or $HasGetEx -or $HasRunEx) {
    Write-Host 'Script-Funktion' -Fore Yellow
    Write-Host 'Gibt alle übergebenen Parameter auf der Konsole aus' -Fore White
    Return
}


Write-Host "`nAlle übergebenen Parameter"

$i = 0
While ($i -lt $Params.Count) {
    $param = $Params[$i]
    if ($param -like "-*") {
        if ($i + 1 -lt $Params.Count -and -not ($Params[$i+1] -like "-*")) {
            # Named parameter with value
            Write-Host ('{0}: {1}' -f $param, $Params[$i+1])
            $i += 2
        } else {
            # Switch parameter
            Write-Host ('Switch: {0}' -f $param)
            $i++
        }
    } else {
        # Positional parameter
        Write-Host ('Positional: {0}' -f $param)
        $i++
    }
}

Write-Host "`nAutomatische Variablen"
Write-Host "`$PSBoundParameters:"
$PSBoundParameters | Format-Table -AutoSize

Write-Host "`n`$args:"
$args

