#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7



<#
	.SYNOPSIS
    Löscht einen lokalen MacOS User, kann ein mobiler Account sein
	Ohne -Force wird der User nicht gelöscht

	.EXAMPLE
    ! ./Remove-MacOS-Mobile-Account -UserLoginName test
	Löscht den Mobilen MacOS User

	.NOTES
    001, 250725, Tom
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

[CmdletBinding(DefaultParameterSetName = 'GetHelp')]
Param (
	[Parameter(Mandatory, ParameterSetName = 'Script')]
	[String]$UserLoginName,
	[Parameter(ParameterSetName = 'Script')]
	[Switch]$Force,

    # Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition

If ($PsCmdlet.ParameterSetName -eq 'Script' -and (-not $Force)) {
	Write-Host "Kein -Force angegeben!" -Fore Magenta
	Write-Host "Es wird NICHTS verändert!" -Fore Magenta
}

# Ist irgend ein GetHelp aktiv?
$IsGetHelpActive = (($GetHelp) -or ($GetHelpCls) -or ($GetEx -ne $Null) -or ($RunEx -ne $Null))

# Wenn kein GetHelp Parameter aktiv ist, aber das ParameterSet GetHelb gewählt ist,
# dann wird -GetHelp aktiviert
If(($PsCmdlet.ParameterSetName -eq 'GetHelp') -and (-not $IsGetHelpActive)) {
    $GetHelp = $True
    $IsGetHelpActive = $True
}



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'



# Root nur prüfen, wenn wir die Hilfe nicht abrufen
If (-not $IsGetHelpActive) {
    ### Root erzwingen
    # 250620 1850
    If ((id -u) -ne 0) {
        Write-Host 'Starte das Script als root'
        If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
            Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
        }	
    
        # Argumente aus den BoundParameters zusammensetzen
        $paramList = @()
        ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
            If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
                $paramList += "-$($kvp.Key)"
            } Else {
                $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
            }
        }
    
        $pwsh = (Get-Command pwsh).Source
    
        If ($paramList.Count -gt 0) {
            # sudo $pwsh $ThisScriptPath @paramList
            $quotedArgs = $paramList -join ' '
            $cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
            sudo bash -c "$cmd"
        } Else {
            sudo $pwsh $ThisScriptPath
        }
        Exit
    }
    
    # Ab hier läuft das Script als root
    Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray
}



### Funcs


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp

# Existiert der User?
$UserExists = Does-MacOS-User-Exists -UserLoginName $UserLoginName

# Existiet der User?
If ($UserExists.UserExists -eq $False) {
	Log 1 "User existiert nicht: $UserLoginName" -Fore Red
	Log 4 'Abbruch' -Fore Red
	Return $False
}



### Main

If ($Force) {
	Log 0 "Lösche: $UserLoginName"
} Else {
	Log 0 "WÜRDE löschen: $UserLoginName (Kein -Force angegeben!)"
}


# Fehlt -Force?
If ($Force -eq $False) {
	Log 1 "Existiert: $UserLoginName"
	If ($UserExists.IsDomainUser) {
		Log 1 'Ist ein Domänen User'
	} Else {
		Log 1 'Ist lokaler MacOS User (kein Domänen User)'
	}

	Log 4 'Ohne -Force wird der User NICHT gelöscht' -Fore Red
	Log 5 'Abbruch' -Fore Red
	Return $False
}



## User löschen

# Domänen User löschen
If ($UserExists.IsDomainUser) {
	Log 1 'Lösche Domänen User'
	# Domänen User Löschen
	# sudo dscl . delete /Users/test
	$CmdArgs = ". delete `"/Users/$UserLoginName`""
	$ResProc = Start-Process-WithTimeout -ExeFilePath 'dscl' `
											-Arguments $CmdArgs `
											-MaxWaitTimeSec 15

	If (Handle-Start-Process-Errors $ResProc '2jfsJc') {
		Log 4 '(Ignoriert)' -Fore Red
	} Else {
		Log 2 'OK' -Fore Green
	}
}


Log 1 'Lösche das User Home Dir'

# sudo rm -rf /Users/test
$CmdArgs = "-c `"rm -rf `"/Users/$UserLoginName`""
$ResProc = Start-Process-WithTimeout -ExeFilePath '/bin/zsh' `
									-Arguments $CmdArgs `
									-MaxWaitTimeSec 15

If (Handle-Start-Process-Errors $ResProc '2jfsJc') {
	Log 4 '(Ignoriert)' -Fore Red
} Else {
	Log 2 'OK' -Fore Green
}

