#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7


<#
	.SYNOPSIS
        Erzeugt auf dem MacOS
        ein neues, lokales Admin-Konto mit Secure-Token

	.PARAMETER CurrentAdminUserName
        Der Name eines aktuellen MacOS Administrators
        .PARAMETER CurrentAdminPassword
        Das PW eines aktuellen MacOS Administrators
	.PARAMETER NewUserName
        Der neue User-Name
	.PARAMETER NewUserPassword
        Das PW des neuen Users

	.EXAMPLE
        ./New-MacOS-LocalAdmin.ps1 -AdminUserName aaa -AdminUserPW bbb -NewUserLoginName ccc -NewUserPW ddd -NewUserFullName 'Hans Muster'
        Erzeugt den neuen lokalen MacOS Admin

	.NOTES
        001, 250707, Tom
        002, 250718, Tom
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingPlainTextForPassword', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

[CmdletBinding(DefaultParameterSetName = 'Script')]
Param (
	[Parameter(Mandatory, ParameterSetName='Script')]
    [String]$AdminUserName,
    [Parameter(Mandatory, ParameterSetName='Script')]
    [String]$AdminUserPW,
    [Parameter(Mandatory, ParameterSetName='Script')]
    [String]$NewUserLoginName,
    [Parameter(Mandatory, ParameterSetName='Script')]
    [String]$NewUserPW,
    [Parameter(Mandatory, ParameterSetName='Script')]
    [String]$NewUserFullName,

	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)
    


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'



# Root nur prüfen, wenn wir die Hilfe nicht abrufen
If ((-Not $GetHelp) -and (-Not $GetHelpCls) -and ($Null -eq $GetEx) -and ($Null -eq $RunEx)) {
    ### Root erzwingen
    # 250620 1850
    If ((id -u) -ne 0) {
        Write-Host 'Starte das Script als root'
        If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
            Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
        }	
    
        # Argumente aus den BoundParameters zusammensetzen
        $paramList = @()
        ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
            If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
                $paramList += "-$($kvp.Key)"
            } Else {
                $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
            }
        }
    
        $pwsh = (Get-Command pwsh).Source
    
        If ($paramList.Count -gt 0) {
            # sudo $pwsh $ThisScriptPath @paramList
            $quotedArgs = $paramList -join ' '
            $cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
            sudo bash -c "$cmd"
        } Else {
            sudo $pwsh $ThisScriptPath
        }
        Exit
    }
    
    # Ab hier läuft das Script als root
    Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray

}    

### Funcs


### Prepare
# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp


Log 0 'Erzeuge neuen lokalen MacOS Admin User'

# Existiert der neue User bereits?
If (Does-MacOS-User-Exists -UserName $NewUserLoginName) {
    Log 4 "User $NewUserLoginName existiert bereits!" -Fore Red
    Log 5 'Abbruch' -Fore Magenta
    # Exit 1
}



### Main

# User erzeugen
New-MacOS-Local-User -AdminUserName $AdminUserName `
    -AdminUserPW $AdminUserPW `
    -NewUserLoginName $NewUserLoginName `
    -NewUserPW $NewUserPW `
    -NewUserFullName $NewUserFullName `

