#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7



<#
	.SYNOPSIS
		Liefert Infos zum Host & den SSF IT Tools
		- Status genützter Dienste
		- Scripts


	.EXAMPLE
		! ./Get-SSF-Info.ps1
		Liefert Infos zum Host & den SSF IT Tools (Dienste, Scripts, …)

	.NOTES
		001, 250708, Tom
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

[CmdletBinding(DefaultParameterSetName = 'Script')]
Param (
	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'


# Root nur prüfen, wenn wir die Hilfe nicht abrufen
If ((-Not $GetHelp) -and (-Not $GetHelpCls) -and ($Null -eq $GetEx) -and ($Null -eq $RunEx)) {
	
	### Root erzwingen
	# 250620 1850
	$IsRoot = $True
	If ((id -u) -ne 0) {
		$IsRoot = $False
	
		Do {
			$response = Read-Host 'Root für mehr Infos aktivieren? (j/n)'
		} While ($response -notmatch '^(j|n)$')
	
		If ($response -eq 'j') {
			Write-Host 'Starte das Script als root'
			If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
				Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
			}	
		
			# Argumente aus den BoundParameters zusammensetzen
			$paramList = @()
			ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
				If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
					$paramList += "-$($kvp.Key)"
				} Else {
					$paramList += "-$($kvp.Key) `"$($kvp.Value)`""
				}
			}
		
			$pwsh = (Get-Command pwsh).Source
		
			If ($paramList.Count -gt 0) {
				# sudo $pwsh $ThisScriptPath @paramList
				$quotedArgs = $paramList -join ' '
				$cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
				sudo bash -c "$cmd"
			} Else {
				# sudo $pwsh $ThisScriptPath
				$cmd = "$pwsh `"$ThisScriptPath`""
				sudo bash -c "$cmd"
			}
			Exit
		}
	
	}

	If ($IsRoot) {
		# Ab hier läuft das Script als root
		Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray
	}
}	



### Funcs


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp

Write-Host 'Hallo!'
Log 0 'tester'
Return


### Main

If ($Print) {
	Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfo
}

If ($GetDetails) {
	Log 0 'dsconfigad -show'
	$dsconfigadOut = & dsconfigad -show 2>$null
	$dsconfigadOut.Split("?n") | % {
		Log 1 $_ -Fore White
	}
}

Return $oHostnamesInfo


