#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7


<#
	.SYNOPSIS
		Liest die MacOS Hostnamen
	.PARAMETER GetDetails
		Liefert Infos von dsconfigad -show
	.PARAMETER Print
		Gibt die Hostnamen auch als Text auf der Konsole aus

	.EXAMPLE
		! ./Get-Hostname.ps1
		Gibt die Hostnamen zurück

	.EXAMPLE
		! ./Get-Hostname.ps1 -GetDetails
		Gibt die Hostnamen zurück und
		gibt auch das Resuultat von dsconfigad -show auf der Konsole aus
		
	.EXAMPLE
		! ./Get-Hostname.ps1 -Print
		Gibt die Hostnamen zurück
		und gibt sie auch als Text auf der Konsole aus
		

	.NOTES
		001, 250610, Tom
		002, 250611, Tom
		Shebang angepasst
		003, 250627, Tom
			Liefert infos zum Domain-join
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

[CmdletBinding(DefaultParameterSetName = 'Script')]
Param (
	# Liefert Infos von dsconfigad -show
	[Parameter(ParameterSetName = 'Script')]
	[Switch]$GetDetails,
	[Parameter(ParameterSetName = 'Script')]
	[Switch]$Print,

	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'



### Funcs


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp


# Hostnamen bestimmen
$oHostnamesInfo = Get-HostNames-Info
# Return $oHostnamesInfo



### Main

If ($Print) {
	Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfo
}

If ($GetDetails) {
	Log 0 'dsconfigad -show'
	$dsconfigadOut = & dsconfigad -show 2>$null
	$dsconfigadOut.Split("?n") | % {
		Log 1 $_ -Fore White
	}
}

Return $oHostnamesInfo


