#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7



<#
	.SYNOPSIS
        Startet VS Code als Root

	.EXAMPLE
		! ./Start-Code-as-Root.ps1
		Startet VS Code als Root

	.NOTES
        001, 250710, Tom
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

Param (
	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)

# Write-Host $PsCmdlet.ParameterSetName


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'

# Pfad zur Visual Studio Code Anwendung
$VsCodeAppPath = '/Applications/Visual Studio Code.app'
# Pfad zur ausführbaren Electron-Datei innerhalb der VS Code App
$VsCodeExecutablePath = "$VsCodeAppPath/Contents/MacOS/Electron"


# Root nur prüfen, wenn wir die Hilfe nicht abrufen
# Ist irgend ein GetHelp aktiv?
$IsGetHelpActive = (($GetHelp) -or ($GetHelpCls) -or ($GetEx -ne $Null) -or ($RunEx -ne $Null))
If (-Not $IsGetHelpActive) {
    ### Root erzwingen
    # 250620 1850
    If ((id -u) -ne 0) {
        Write-Host 'Starte das Script als root'
        If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
            Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
        }	
    
        # Argumente aus den BoundParameters zusammensetzen
        $paramList = @()
        ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
            If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
                $paramList += "-$($kvp.Key)"
            } Else {
                $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
            }
        }
    
        $pwsh = (Get-Command pwsh).Source
    
        If ($paramList.Count -gt 0) {
            # sudo $pwsh $ThisScriptPath @paramList
            $quotedArgs = $paramList -join ' '
            $cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
            sudo bash -c "$cmd"
        } Else {
            sudo $pwsh $ThisScriptPath
        }
        Exit
    }
    
    # Ab hier läuft das Script als root
    Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray
}


### Funcs


# Ist VS Code installiert?
Function Is-CodeApp-Installed() {
    Param (
        [Parameter(Mandatory)]
        [String]$VsCodeAppPath,
        [Parameter(Mandatory)]
        [String]$VsCodeExecutablePath
	)

	
	If (Test-Path $VsCodeAppPath) {
		If (Test-Path $VsCodeExecutablePath) {
			Return $True
		}
	}
	Return $False
}


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp


$IsCsVodeInstalled = Is-CodeApp-Installed -VsCodeAppPath $VsCodeAppPath `
						-VsCodeExecutablePath $VsCodeExecutablePath


### Main

Log 0 'Starte VS Code als Root'
If ($IsCsVodeInstalled) {
	# & Operator, damit der Befehl im Hintergrund ausgeführt wird
	# sudo $VsCodeExecutablePath &

    # Blockiert die Shell:
	# sudo $VsCodeExecutablePath
    # 'sudo open -a "Visual Studio Code"' für sichtbaren Start als Root
    # und um die Shell nicht zu blockieren.
    # Der 'open' Befehl handhabt das Hintergrund-Starten für GUI-Apps automatisch
    sudo open -a "Visual Studio Code"

    # Müsste auch klappen:
    # sudo open -a "$VsCodeAppPath"

} Else {
	Log 4 'VS Code ist nicht installiert' -Fore Red
}

