#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7


<#
	.SYNOPSIS
        Installiert AnyDesk von:
        https://www.akros.ch/it/AnyDesk/AnyDesk_Akros_MacOS_Client_NotNotarized.dmg

	.EXAMPLE
        ! ./Install-AnyDesk.ps1
        Installiert AnyDesk auf dem MacOS

	.NOTES
        001, 250626, Tom
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

[CmdletBinding(DefaultParameterSetName = 'Script')]
Param (
	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition


# Root nur prüfen, wenn wir die Hilfe nicht abrufen
If ((-Not $GetHelp) -and (-Not $GetHelpCls) -and ($Null -eq $GetEx) -and ($Null -eq $RunEx)) {
    ### Root erzwingen
    # 250620 1850
    If ((id -u) -ne 0) {
        Write-Host 'Starte das Script als root'
        If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
            Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
        }	
    
        # Argumente aus den BoundParameters zusammensetzen
        $paramList = @()
        foreach ($kvp in $PSBoundParameters.GetEnumerator()) {
            if ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
                $paramList += "-$($kvp.Key)"
            } else {
                $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
            }
        }
    
        $pwsh = (Get-Command pwsh).Source
    
        if ($paramList.Count -gt 0) {
            # sudo $pwsh $ThisScriptPath @paramList
            $quotedArgs = $paramList -join ' '
            $cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
            sudo bash -c "$cmd"
        } else {
            sudo $pwsh $ThisScriptPath
        }
    
        exit
    }
    
    # Ab hier läuft das Script als root
    Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray
}



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'

$DMG_URL = 'https://www.akros.ch/it/AnyDesk/AnyDesk_Akros_MacOS_Client_NotNotarized.dmg'
$DMG_TEMP_PATH = '/tmp/AnyDesk_Akros.dmg'
$MOUNT_POINT = '/Volumes/AnyDesk'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp



### Main

Log 0 'Installiere AnyDesk'
Log 1 'Lade AnyDesk DMG herunter'

try {
    Invoke-WebRequest -Uri $DMG_URL -OutFile $DMG_TEMP_PATH -UseBasicParsing
} catch {
    Log 4 '❌ Fehler beim Download' -Fore red
    exit 1
}

Log 1 'Entferne Quarantäne-Markierung…'
# $xattrOutput = & xattr $DMG_TEMP_PATH 2>$null
$ResProc = Invoke-Process-WithTimeout -ExeFilePath xattr `
                                        -Arguments "$DMG_TEMP_PATH" `
                                        -MaxWaitTimeSec 15

# Return $ResProc
If (Handle-Invoke-Process-Errors $ResProc '2jfaGa') {
    Log 4 'Abbruch' -Fore Red
    Break Script
}

$xattrOutput = $ResProc.StdOut | % { $_.Trim() }

if ($xattrOutput -match 'com.apple.quarantine') {
    # & xattr -d com.apple.quarantine $DMG_TEMP_PATH
    $ResProc = Invoke-Process-WithTimeout -ExeFilePath xattr `
                                            -Arguments "-d com.apple.quarantine `"$DMG_TEMP_PATH`"" `
                                            -MaxWaitTimeSec 15

    # Return $ResProc
    If (Handle-Invoke-Process-Errors $ResProc '2jfaGb') {
        Log 4 'Abbruch' -Fore Red
        Exit 1
    }

    Log 2 'Quarantäne-Markierung entfernt'
} else {
    Log 2 'Keine Quarantäne-Markierung vorhanden'
}

Log 1 'Mounten der DMG-Datei…'
# $attachResult = & hdiutil attach $DMG_TEMP_PATH -nobrowse -quiet
$ResProc = Invoke-Process-WithTimeout -ExeFilePath hdiutil `
                                        -Arguments "attach `"$DMG_TEMP_PATH`" -nobrowse -quiet" `
                                        -MaxWaitTimeSec 15

# Return $ResProc
If (Handle-Invoke-Process-Errors $ResProc '2jfaGc') {
    Log 4 '❌ Fehler beim Mounten' -Fore Red
    Log 4 'Abbruch' -Fore Red
    Exit 1
}

# $attachResult = $ResProc.StdOut | % { $_.Trim() }


# Suche nach .app im gemounteten Volume
$APP_SOURCE = Get-ChildItem -Path $MOUNT_POINT -Filter *.app -Depth 0 | Select-Object -First 1

if (-not $APP_SOURCE) {
    Log 4 '❌ Keine .app-Datei gefunden im gemounteten Volume' -Fore Red
    # & hdiutil detach $MOUNT_POINT -quiet
    $ResProc = Invoke-Process-WithTimeout -ExeFilePath hdiutil `
                                            -Arguments "detach `"$MOUNT_POINT`" -quiet" `
                                            -MaxWaitTimeSec 15

    # Return $ResProc
    If (Handle-Invoke-Process-Errors $ResProc '2jfaGd') {
        Log 4 '❌ Fehler beim Detach' -Fore Red
        Log 4 'Abbruch' -Fore Red
        Exit 1
    }

    exit 1
}

Log 1 "Kopiere $($APP_SOURCE.Name) nach /Applications…"
try {
    Copy-Item -Path $APP_SOURCE.FullName -Destination '/Applications/' -Recurse -Force
} catch {
    Log 4 '❌ Fehler beim Kopieren' -Fore Red
    exit 1
}

Log 1 'Aushängen des Volumes…'
Start-Sleep -Seconds 10

# & hdiutil detach $MOUNT_POINT -quiet
$ResProc = Invoke-Process-WithTimeout -ExeFilePath hdiutil `
                                        -Arguments "detach `"$MOUNT_POINT`" -quiet" `
                                        -MaxWaitTimeSec 15

# Return $ResProc

If ($ResProc.ExitCode -eq 16) {
    # Die Ressource ist noch belegt ("Resource busy")
    Log 2 "Ressource ist noch belegt: $MOUNT_POINT" -Fore Cyan
} Else {
    If (Handle-Invoke-Process-Errors $ResProc '2jfaGe') {
        Log 4 '❌ Fehler beim Detach' -Fore Red
        Log 4 'Abbruch' -Fore Red
        Exit 1
    }
}


Log 1 'Lösche Setup-File'
Start-Sleep -Seconds 2
Remove-Item -Path $DMG_TEMP_PATH -Force

Log 1 '✅ AnyDesk wurde installiert!' -Fore Green


