#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Liest die MacOS Hostnamen 

# 001, 250610, Tom
# 002, 250611, Tom
#  Shebang angepasst
# 003, 250627, Tom
#	Liefert infos zum Domain-join


# scutil --get ComputerName
# scutil --get HostName
# scutil --get LocalHostName


Param (
	# Liefert Infos von dsconfigad -show
	[Switch]$GetDetails,
	[Switch]$Print
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'



### Funcs


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters


# Hostnamen bestimmen
$oHostnamesInfo = Get-HostNames-Info
# Return $oHostnamesInfo



### Main

If ($Print) {
	Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfo
}

If ($GetDetails) {
	Log 0 'dsconfigad -show'
	$dsconfigadOut = & dsconfigad -show 2>$null
	$dsconfigadOut.Split("?n") | % {
		Log 1 $_ -Fore White
	}
}

Return $oHostnamesInfo


