#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Gibt alle übergebene Params aus, auch Named-Parameter

# 001, 250612, Tom


[CmdletBinding()]
Param(
    [Parameter(ValueFromRemainingArguments)]
    [Object[]]$Params
)

Write-Host "`nAlle übergebenen Parameter"

$i = 0
while ($i -lt $Params.Count) {
    $param = $Params[$i]
    if ($param -like "-*") {
        if ($i + 1 -lt $Params.Count -and -not ($Params[$i+1] -like "-*")) {
            # Named parameter with value
            Write-Host ('{0}: {1}' -f $param, $Params[$i+1])
            $i += 2
        } else {
            # Switch parameter
            Write-Host ('Switch: {0}' -f $param)
            $i++
        }
    } else {
        # Positional parameter
        Write-Host ('Positional: {0}' -f $param)
        $i++
    }
}

Write-Host "`nAutomatische Variablen"
Write-Host "`$PSBoundParameters:"
$PSBoundParameters | Format-Table -AutoSize

Write-Host "`n`$args:"
$args

