#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Trennt das MacBook von einer Domäne
# Fragt nach Usernamen und PW, wenn nicht angegeben

# 001, 250701, Tom
# 002, 250704, Tom

[CmdletBinding(SupportsShouldProcess)]
Param (
	# Optional ein UserName
	[Object]$UserName,
	# Optional ein PW
	[Object]$PW
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition


### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'


### Root erzwingen
# 250620 1850
If ((id -u) -ne 0) {
    Write-Host 'Starte das Script als root'
	If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
		Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
	}	

    # Argumente aus den BoundParameters zusammensetzen
    $paramList = @()
    ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
        If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
            $paramList += "-$($kvp.Key)"
        } Else {
            $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
        }
    }

    $pwsh = (Get-Command pwsh).Source

    If ($paramList.Count -gt 0) {
        # sudo $pwsh $ThisScriptPath @paramList
		$quotedArgs = $paramList -join ' '
		$cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
		sudo bash -c "$cmd"
    } Else {
        # sudo $pwsh $ThisScriptPath
		$cmd = "$pwsh `"$ThisScriptPath`""
		sudo bash -c "$cmd"
	}
    Exit
}

# Ab hier läuft das Script als root
Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters

# Hostnamen bestimmen
$oHostnamesInfo = Get-HostNames-Info
# Return $oHostnamesInfo


### Main


## 1. Unjoin
# Validiert, ob der Computer in einer Domäne ist
$UnjoinOK = Unjoin-MacOS-from-Domain -UserName $UserName -PW $PW

## Wenn alles OK, den Hosnamen ohne Domäne setzen
If ($UnjoinOK) {
	# Nur noch den aktuellen Hostnamen ohne Domäne setzen
	$NewHostName = Get-Current-HostName $oHostnamesInfo
	# Write-Host "NewHostName: $NewHostName"
	
	# Den Hostnamen ohne Domäne setzen
	Set-HostNames -NewHostName $NewHostName `
				-DomainName $Null `
				-Force:$True `
				-Dbg:$False
	
	Log 1 'Lösche DNS Cache'
	Clear-DNS-Cache

	Log 0 'Neue MacOS Hostnamen'
	$oHostnamesInfoNeu = Get-HostNames-Info
	Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfoNeu

}

Return $UnjoinOK
