#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Erzeugt / aktualisiert diese Datei:
# 	/etc/paths.d/NinjaOne
#   Mit dem Inhalt:
# 	/Library/Scripts/SSF/NinjaOne/
# Damit wird der Pfad in den systemweiten PATH aufgenommen,
# so dass auch die PowerShell-Skripte ohne Verzeichnisangabe aufgerufen werden können


# !Ex




# 001, 250707, Tom

[CmdletBinding(DefaultParameterSetName = 'HostNameOnly')]
Param (
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
# Das File wird erzeugt
$PathsDFile = "/etc/paths.d/NinjaOne"
# Dieser Pfad wird eingetragen
$PathToAdd = "/Library/Scripts/SSF/NinjaOne/"


### Root erzwingen
# 250620 1850
If ((id -u) -ne 0) {
    Write-Host 'Starte das Script als root'
	If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
		Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
	}	

    # Argumente aus den BoundParameters zusammensetzen
    $paramList = @()
    ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
        If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
            $paramList += "-$($kvp.Key)"
        } Else {
            $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
        }
    }

    $pwsh = (Get-Command pwsh).Source

    If ($paramList.Count -gt 0) {
        # sudo $pwsh $ThisScriptPath @paramList
		$quotedArgs = $paramList -join ' '
		$cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
		sudo bash -c "$cmd"
    } Else {
        # sudo $pwsh $ThisScriptPath
		$cmd = "$pwsh `"$ThisScriptPath`""
		sudo bash -c "$cmd"
	}
    Exit
}

# Ab hier läuft das Script als root
Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray



### Funcs


# Erzeugt oder aktualisiert die Datei /etc/paths.d/NinjaOne
Function Chack-and-Update-PathsDFile {
	Param (
		[Parameter(Mandatory)]
		[String]$PathsDFile,
		[Parameter(Mandatory)]
		[String]$PathToAdd
	)

	# Prüfen, ob das File existiert
	If (Test-Path $PathsDFile) {
		# Das File existiert bereits
		# Ist der Inhalt korrekt?
		$CurrentContent = Get-Content $PathsDFile -Raw
		If ($CurrentContent.Trim() -eq $PathToAdd.Trim()) {
			Log 1 'Die Datei ist korrekt' -Fore Green
		} Else {
			Log 1 'Der Pfad ist falsch:' -Fore Red
			Log 2 "Ist : $CurrentContent"
			Log 2 "Soll: $PathToAdd"
			Log 1 'Setze den Pfad neu' -Fore Cyan
		}
	} Else {
		Log 1 "Erzeuge: $PathsDFile" -Fore Cyan
	}

	Set-Content -Path $PathsDFile -Value $PathToAdd -NoNewline
	chmod 644 $PathsDFile

	Log 1 'Alles OK' -Fore Green
}



### Prepare

## Script-Pfade auflösen
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
$UnjoinDomain_ps1 = Join-Path $ScriptDir $UnjoinDomain_ps1

# Lib laden
. $TomLibMacOS_ps1 $PSBoundParameters



### Main

# Systemzustand prüfen
Log 0 "Prüfe: $PathsDFile"

Chack-and-Update-PathsDFile -PathsDFile $PathsDFile -PathToAdd $PathToAdd

