#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Ergänzt ein NinjaOne Textfeld um eine neue Zeile

# 001, 250611, Tom


# !Ex
# /Library/Scripts/SSF/NinjaOne/Add-NinjaOne-TextField-Line.ps1 -FieldName ssfMacOsFileVaultKey -LineToAdd TomTom


[CmdletBinding()]
Param(
	[Parameter(Mandatory, ParameterSetName = 'Script')]
	[String]$FieldName,

	[Parameter(Mandatory, ParameterSetName = 'Script')]
	[String]$LineToAdd,

	[Parameter(ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp
)


If ($GetHelp) {
	Write-Host "`nHilfe: " -NoNewline
	Write-Host $MyInvocation.MyCommand.Definition -Fore Cyan
	
	@'
	Ergänzt ein NinjaOne Textfeld um eine neue Zeile
	
'@ -Split "`n" | % { Write-Host $_.Trim() }

	@"
	!Ex
	$($MyInvocation.MyCommand.Definition) -FieldName ssfMacOsFileVaultKey -LineToAdd TomTom
"@ -Split "`n" | % { Write-Host $_.Trim() -Fore Green }
	
	Return
}


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
$NinjaCliPath = '/Applications/NinjaRMMAgent/programdata/ninjarmm-cli'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters



### Main

Write-Verbose "Prüfe, ob das NinjaOne CLI-Tool existiert: '$NinjaCliPath'"
If (-not (Test-Path $NinjaCliPath)) {
	Log 4 "Das NinjaOne CLI-Tool wurde unter '$NinjaCliPath' nicht gefunden" -Fore Red
	Return
}

Write-Verbose "Rufe aktuellen Inhalt des Feldes '$FieldName' ab …"
try {
	# Der Backtick am Zeilenende ist für Multi-Line-Befehle in PowerShell
	# Die `Get-Content` umgeht potentielle Probleme mit der Zeilenumbruchinterpretation
	# bei der direkten Ausgabe in eine Variable.
	$CurrentContent = & "$NinjaCliPath" get "$FieldName" | Out-String | ForEach-Object { $_.Trim() }

	# Behandeln, wenn das Feld (bisher) leer ist. 
	# Out-String kann einen leeren String oder nur Leerzeichen/Zeilenumbrüche zurückgeben.
	If ([string]::IsNullOrWhiteSpace($CurrentContent)) {
		$UpdatedContent = $LineToAdd
	} Else {
		Write-Verbose "Aktueller Inhalt des Feldes '$FieldName':`n$CurrentContent"
		# Füge die neue Zeile mit einem Zeilenumbruch hinzu
		$UpdatedContent = "$CurrentContent`n$LineToAdd"
	}

	Write-Verbose "Setze aktualisierten Inhalt für Feld '$FieldName'..."
	# Verwende die doppelten Anführungszeichen, um sicherzustellen, dass Leerzeichen und Zeilenumbrüche korrekt übergeben werden.
	$cliOutput = & "$NinjaCliPath" set "$FieldName" "$UpdatedContent" 
	$LastExitOK, $LastExitNOK = Is-LastExitCode-AllOK $LastExitCode

	if ($LastExitOK) {
		Log 4 "Fehler beim Setzen des Feldes '$FieldName'. Exit Code: $LastExitCode. Output: $cliOutput" -Fore Red
	} else {
		LLog 1 "Zeile erfolgreich zu Feld '$FieldName' hinzugefügt." -Fore Green
		Write-Verbose "Der aktualisierte Inhalt ist: '$UpdatedContent'"
	}

} catch {
	Log 4 "Ein unerwarteter Fehler ist aufgetreten: $($_.Exception.Message)" -Fore Red
}

