#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM, Unix (LF)

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingPlainTextForPassword', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Erzeugt auf dem MacOS
# ein neues, lokales Admin-Konto mit Secure-Token

# 001, 250707, Tom


Param (
	[Parameter(Mandatory)]
    [String]$CurrentAdminUserName,
    [Parameter(Mandatory)]
    [String]$CurrentAdminPassword,
    [Parameter(Mandatory)]
    [String]$NewUserName,
    [Parameter(Mandatory)]
    [String]$NewUserPassword
)
    


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'


### Root erzwingen
# 250620 1850
If ((id -u) -ne 0) {
    Write-Host 'Starte das Script als root'
	If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
		Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
	}	

    # Argumente aus den BoundParameters zusammensetzen
    $paramList = @()
    ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
        If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
            $paramList += "-$($kvp.Key)"
        } Else {
            $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
        }
    }

    $pwsh = (Get-Command pwsh).Source

    If ($paramList.Count -gt 0) {
        # sudo $pwsh $ThisScriptPath @paramList
		$quotedArgs = $paramList -join ' '
		$cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
		sudo bash -c "$cmd"
    } Else {
        sudo $pwsh $ThisScriptPath
    }
    Exit
}

# Ab hier läuft das Script als root
Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray


### Funcs


# Prüft, ob der locale MacOS-Benutzer existiert
# Funktioniert beides:
# Test-MacOS-User-Exists nypadmin
#   True
# Test-MacOS-User-Exists nypAdmin
#   True
Function Does-MacOS-User-Exists {
    param(
        [Parameter(Mandatory)]
        [String]$UserName
    )

    # Prüft, ob der Benutzer existiert (nutzt dscl)
    $Null = dscl . -read "/Users/$UserName" 2>$null
    If ($LASTEXITCODE -eq 0) {
        Return $True
    } Else {
        Return $False
    }
}


# Sucht eine freie UniqueID
Function New-UniqueID {
    $AllUsers = dscl . -list /Users UniqueID
    $UsedIDs = $AllUsers | % { ($_ -Split('\s+'))[1] }
    $UniqueID = 501
    While ($UsedIDs -contains "$UniqueID") {
        $UniqueID++
    }
    Return $UniqueID
}


# Erzeugt einen neuen lokalen Administrator
Function New-MacOS-Local-User() {
    Param (
        [Parameter(Mandatory)]
        [String]$CurrentAdminUserName,
        [Parameter(Mandatory)]
        [String]$CurrentAdminPassword,
        [Parameter(Mandatory)]
        [String]$NewUserName,
        [Parameter(Mandatory)]
        [String]$NewUserPassword,
        [Parameter(Mandatory)]
        [String]$UniqueID
    )

    ## Den neuen User anlegen
    Log 2 'Erzeuge den User'
    dscl . -create /Users/$NewUserName
    
    # dscl . -read /Users/nypadmin UserShell
    # /bin/zsh
    dscl . -create /Users/$NewUserName UserShell /bin/zsh
    dscl . -create /Users/$NewUserName RealName "$NewUserName"
    dscl . -create /Users/$NewUserName UniqueID "$UniqueID"
    
    Log 2 'Weise Admin-Rechte zu'
    # Die PrimaryGroupID 20 steht auf macOS für die Gruppe staff.
    # Standardmäßig werden alle normalen Benutzer (einschließlich Administratoren) auf macOS
    # der Gruppe staff zugeordnet, deren numerische Gruppen-ID (GID) 20 ist.
    # Diese Gruppe ist die primäre Gruppe für fast alle lokalen Benutzerkonten auf macOS
    dscl . -create /Users/$NewUserName PrimaryGroupID 20
    dscl . -create /Users/$NewUserName NFSHomeDirectory /Users/$NewUserName
    dscl . -passwd /Users/$NewUserName "$NewUserPassword"
    dscl . -append /Groups/admin GroupMembership $NewUserName

    # Kurz warten, damit der User angelegt ist
    Start-Sleep -Milliseconds 3500

    ## Das Secure Token vergeben
    # !KH9^9: Die Passwörte müssen in Anführungszeichen stehen, damit sie korrekt verarbeitet werden
    #           Sonst interpretiert die zsh ein Passwort mit einem führenden Minuszeichen als Stopp der Parameter
    
    Log 2 'Weise das Secure-Token zu'
    sysadminctl -secureTokenOn $NewUserName -password "`"$NewUserPassword`"" -adminUser $CurrentAdminUserName -adminPassword  "`"$CurrentAdminPassword`""
}



### Prepare
# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters


Log 0 'Erzeuge neuen lokalen MacOS Admin User'

# Existiert der neue User bereits?
If (Does-MacOS-User-Exists -UserName $NewUserName) {
    Log 4 "User $NewUserName existiert bereits!" -Fore Red
    Log 5 'Abbruch' -Fore Magenta
    # Exit 1
}



### Main

# User erzeugen
New-MacOS-Local-User -CurrentAdminUserName $CurrentAdminUserName `
    -CurrentAdminPassword $CurrentAdminPassword `
    -NewUserName $NewUserName `
    -NewUserPassword $NewUserPassword `
    -UniqueID (New-UniqueID)

