#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM, Unix (LF)

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Trennt das MacBook von einer Domäne
# Fragt nach Usernamen und PW, wenn nicht angegeben

# 001, 250701, Tom
# 002, 250704, Tom

[CmdletBinding(SupportsShouldProcess)]
Param (
	# Optional ein UserName
	[Object]$UserName,
	# Optional ein PW
	[Object]$PW
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)


### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters

# Hostnamen bestimmen
$oHostnamesInfo = Get-HostNames-Info
# Return $oHostnamesInfo


### Main

## 1. Unjoin
$UnjoinOK = Unjoin-MacOS-from-Domain -UserName $UserName -PW $PW

## Wenn alles OK, den Hosnamen ohne Domäne setzen
If($UnjoinOK) {
	# Wenn LocalHostName definiert ist, diesen nützen
	$NewHostName = $oHostnamesInfo.MacOS_LocalHostName
	If ([String]::IsNullOrWhiteSpace($NewHostName)) {
		$NewHostName = $oHostnamesInfo.MacOS_ComputerName
	}
	
	# Den Hostnamen ohne Domäne setzen
	Set-HostNames -Name $NewHostName `
				-DomainName $Null `
				-Force:$True
	
	# DNS Cache löschen
	Clear-DNS-Cache
}

Return $UnjoinOK
