#!/usr/local/bin/pwsh

# !9^9 Nur UTF8 für MacOS, KEIN BOM

# Setzt den MacOS Hostnamen 
# Behandelt auch das Problem, wenn das MacOS Domain-Joined ist
# 
# 
# 
# 

# 001, 250610, Tom
# 002, 250611, Tom
#  Shebang angepasst
# 003, 250627, Tom
#	Wenn das MacOS Domain-Joined ist,
#	dann wird gefragt, ob der Domain-join 
#	getrennt und wieder neu hergestellt werden soll
#	damit das AD den neuen Hostnamen kennt



Param (
    [Parameter(Mandatory)]
    [String]$HostName,
    [Switch]$Force
)


If (-not $Force) {
	Write-Host "Kein -Force angegeben!" -Fore Magenta
	Write-Host "Es wird NICHTS verändert!" -Fore Magenta
}


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
$IsMacOsDomainJoined_ps1 = 'Is-MacOs-Domain-joined.ps1'
$GetHostname_ps1 = 'Get-Hostname.ps1'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters

## Script-Pfade auflösen
$GetHostname_ps1 = Join-Path $ScriptDir $GetHostname_ps1
$IsMacOsDomainJoined_ps1 = Join-Path $ScriptDir $IsMacOsDomainJoined_ps1
# $IsMacOsDomainJoined = & $IsMacOsDomainJoined_ps1

## Infos zum Host abrufen
$oHostnamesInfo = & $GetHostname_ps1
# Return $oHostnamesInfo


## Sind wir im LAN / VPN?
$IsComputerInDomainLAN = Is-Computer-in-Domain-LAN -Domain 'akros.ch'



### Main

## Aktuelle Host infos ausgeben
Write-Host "`nAktuelle Hostnamen" -Fore Magenta
Write-Host ($oHostnamesInfo | Out-String)


## Ist der Host Domain-joined?
If ($oHostnamesInfo.IsDomainJoined) {
	
	## Haben wir Zugriff zur Domäne?	
	If (-Not $IsComputerInDomainLAN) {
		Write-Host 'Notebook ist Domain-Joined, ist aber nicht imm LAN/VPN' -Fore Red
		Write-Host 'Deshalb kann der Host nicht umbenannt werden' -Fore Red
		Write-Host 'Abbruch' -Fore Red
		Break Script
	}
	
	Write-Host "`nDer Computer ist Domain-Joined" -Fore Red
	Write-Host 'Der Join muss getrennt und wieder initiiert werden' -Fore Red
	$Antwort = Get-JaNein -Frage 'Trotzdem fortfahren?'
	
	If (-Not $Antwort) {
		Write-Host 'Abbruch' -Fore Red
		Break Script
	}
	
	
	## OK, Domain join trennen und neu einrichten
	
	
	
	
}


If ($Force) {
	Write-Host "`nSetze Hostnamen" -Fore Magenta
} Else {
	Write-Host "`nWÜRDE Hostnamen setzen" -Fore Magenta
}
Set-HostNames -Name $HostName -oHostnamesInfo $oHostnamesInfo `
				-Force:$Force


Write-Host "`nNeue Hostnamen" -Fore Magenta
# Infos zum Host abrufen
$oHostnamesInfoNeu = & $GetHostname_ps1
Write-Host ($oHostnamesInfoNeu | Out-String)



