#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM

# Installiert AnyDesk von:
# https://www.akros.ch/it/AnyDesk/AnyDesk_Akros_MacOS_Client_NotNotarized.dmg


# 001, 250626, Tom


[CmdletBinding()]
Param ()


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition


### Root erzwingen
# 250620 1850
If ((id -u) -ne 0) {
    Write-Host 'Starte das Script als root'

    # Argumente aus den BoundParameters zusammensetzen
    $paramList = @()
    foreach ($kvp in $PSBoundParameters.GetEnumerator()) {
        if ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
            $paramList += "-$($kvp.Key)"
        } else {
            $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
        }
    }

    $pwsh = (Get-Command pwsh).Source

    if ($paramList.Count -gt 0) {
        sudo $pwsh $ThisScriptPath @paramList
    } else {
        sudo $pwsh $ThisScriptPath
    }

    exit
}


# Ab hier läuft das Script als root
Write-Host "`nScript läuft jetzt als root`n`n" -Fore Gray



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'

$DMG_URL = 'https://www.akros.ch/it/AnyDesk/AnyDesk_Akros_MacOS_Client_NotNotarized.dmg'
$DMG_TEMP_PATH = '/tmp/AnyDesk_Akros.dmg'
$MOUNT_POINT = '/Volumes/AnyDesk'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters



### Main

Write-Host 'Lade AnyDesk DMG herunter…'
try {
    Invoke-WebRequest -Uri $DMG_URL -OutFile $DMG_TEMP_PATH -UseBasicParsing
} catch {
    Write-Error '❌ Fehler beim Download'
    exit 1
}

Write-Host 'Entferne Quarantäne-Markierung…'
$xattrOutput = & xattr $DMG_TEMP_PATH 2>$null
if ($xattrOutput -match 'com.apple.quarantine') {
    & xattr -d com.apple.quarantine $DMG_TEMP_PATH
    Write-Host 'Quarantäne-Markierung entfernt'
} else {
    Write-Host 'Keine Quarantäne-Markierung vorhanden'
}

Write-Host 'Mounten der DMG-Datei…'
$attachResult = & hdiutil attach $DMG_TEMP_PATH -nobrowse -quiet
if ($LASTEXITCODE -ne 0) {
    Write-Error '❌ Fehler beim Mounten'
    exit 1
}

# Suche nach .app im gemounteten Volume
$APP_SOURCE = Get-ChildItem -Path $MOUNT_POINT -Filter *.app -Depth 0 | Select-Object -First 1

if (-not $APP_SOURCE) {
    Write-Error '❌ Keine .app-Datei gefunden im gemounteten Volume'
    & hdiutil detach $MOUNT_POINT -quiet
    exit 1
}

Write-Host "Kopiere $($APP_SOURCE.Name) nach /Applications…"
try {
    Copy-Item -Path $APP_SOURCE.FullName -Destination '/Applications/' -Recurse -Force
} catch {
    Write-Error '❌ Fehler beim Kopieren'
    exit 1
}

Write-Host 'Aushängen des Volumes…'
& hdiutil detach $MOUNT_POINT -quiet

Write-Host 'Lösche Setup-File'
Start-Sleep -Seconds 2
Remove-Item -Path $DMG_TEMP_PATH -Force

Write-Host '✅ AnyDesk wurde installiert!'


