#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM, Unix (LF)

# Liest die MacOS Hostnamen 

# 001, 250610, Tom
# 002, 250611, Tom
#  Shebang angepasst
# 003, 250627, Tom
#	Liefert infos zum Domain-join


# scutil --get ComputerName
# scutil --get HostName
# scutil --get LocalHostName


Param (
	[Switch]$Print
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'

$IsMacOsDomainJoined_ps1 = 'Is-MacOs-Domain-joined.ps1'



### Funcs


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters


# Ist das Gerät Domain-joined?
$IsMacOsDomainJoined_ps1 = Join-Path $ScriptDir $IsMacOsDomainJoined_ps1
$IsMacOsDomainJoined = & $IsMacOsDomainJoined_ps1


# Hostnamen bestimmen
$oHostnamesInfo = [PSCustomObject][Ordered]@{
	IsDomainJoined = $IsMacOsDomainJoined
	ComputerName = "$(scutil --get ComputerName 2>$null)"
	HostName = "$(scutil --get HostName 2>$null)"
	LocalHostName = "$(scutil --get LocalHostName 2>$null)"
    LocalHostNameEffektiv = "$(scutil --get LocalHostName 2>$null).local"
}
# Return $Hostnames



### Main

If ($Print) {
	Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfo
}

Return $oHostnamesInfo


