#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7


<#
	.SYNOPSIS
    Gibt auf der Konsole die Shell-Farben aus
	
  .PARAMETER Full
    Zeigt mehr Beispiele an
  
	.EXAMPLE
    ! ./Get-ShellColors.ps1
    Erzeugt die Standard-Farbpalette

	.EXAMPLE
    ! ./Get-ShellColors.ps1 -Full
    Erzeugt die erweiterte Farbpalette

	.NOTES
    001, 190504, tom-agplv3@jig.ch
    002, 250709, tom
      Neu:
      -Full
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]
[CmdletBinding(DefaultParameterSetName = 'Script')]
Param(
  [Parameter(ParameterSetName = 'Script')]
  # Zeigt eine detailliertere Ansicht
  [Switch]$Full,

	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp
)


If ($GetHelp) {
  Write-Host 'Gibt auf der Konsole die Shell-Farben aus' -Fore Cyan
  Write-Host 'Parameter -Full: Erzeugt die erweiterte Palette' -Fore Cyan
  Break Script
}


Function Show-Colors() {
  $colors = [Enum]::GetValues( [ConsoleColor] )
  $max = ($colors | % { "$_ ".Length } | Measure-Object -Maximum).Maximum
  foreach( $color in $colors ) {
    Write-Host (" {0,2} {1,$max} " -f [int]$color,$color) -NoNewline
    Write-Host "$color" -Foreground $color
  }
}


Function Show-Colorgrid([Switch]$SplitLines) {
	$colors = [enum]::GetValues([System.ConsoleColor])
	Foreach ($bgcolor in $colors) {

    # Eine leere Zeile erzeugen?
    If ($SplitLines) {
      # Die Zeile aufbauen
      Foreach ($fgcolor in $colors) { 
        Write-Host " $(' '* "$fgcolor".Length) |" -ForegroundColor $bgcolor -BackgroundColor $bgcolor -NoNewLine 
      }
      # Die Zeile abschliessem
      Write-Host ''
    }

    # Die Zeile mit den Darben aufbauen
		Foreach ($fgcolor in $colors) { 
      Write-Host " $fgcolor |" -ForegroundColor $fgcolor -BackgroundColor $bgcolor -NoNewLine 
    }
    # Die Zeile abschliessem
		Write-Host " on $bgcolor"

    # Eine leere Zeile erzeugen?
    If ($SplitLines) {
      # Die Zeile aufbauen
      Foreach ($fgcolor in $colors) { 
        Write-Host " $(' '* "$fgcolor".Length) |" -ForegroundColor $bgcolor -BackgroundColor $bgcolor -NoNewLine 
      }
      # Die Zeile abschliessem
      Write-Host ''
    }

	}
}


Function Show-Colorgrid-Full() {
	$colors = [enum]::GetValues([System.ConsoleColor])
  $MaxColLen = ($colors | % { "$_".length } | measure -Maximum).Maximum
	Foreach ($bgcolor in $colors) {
    Write-Host "`nHintergrund: $bgcolor"
		Foreach ($fgcolor in $colors) { 
      # Farbe anzeigen
      Write-Host ("{0,$MaxColLen}: " -f $fgcolor) -NoNewline
      # Test-Text
      Write-Host 'Lorem ipsum dolor sit Amet, consetetur Sadipscing elitr' -ForegroundColor $fgcolor `
                                                                           -BackgroundColor $bgcolor -NoNewline
      # Zeile abschliessen mit Standardfarben
      Write-Host ''
    }
	}
}


Write-Host "`nColor-Grid:"
Show-Colorgrid

Write-Host "`nColor-Grid Split:"
Show-Colorgrid -SplitLines

If ($Full) {
  Write-Host "`nColor-Grid Full:"
  Show-Colorgrid-Full
}

Write-Host "`nColors:"
Show-Colors

Write-Host "`n"
