#!/usr/local/bin/pwsh
# !9^9 Unix (LF), nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7



<#
	.SYNOPSIS
		Damit die SSF-Scripts ohne Verzeichnisangabe aufgerufen werden können,
		wird der Pfad in den systemweiten PATH aufgenommen.
		Erzeugt / aktualisiert diese Datei:
		  /etc/paths.d/NinjaOne
		Mit dem Inhalt:
		  /Library/Scripts/SSF/NinjaOne/

	.EXAMPLE
		! ./Set-pathsd-NinjaOne.ps1
		Erzeugt / aktualisiert /etc/paths.d/NinjaOne

	.NOTES
		001, 250707, Tom
#>

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]

[CmdletBinding(DefaultParameterSetName = 'Script')]
Param (
	# Get-Help Parameter
	# 005, 200314
	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelp,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Switch]$GetHelpCls,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$GetEx,

	[Parameter(ValueFromPipeline, ValueFromPipelineByPropertyName, ParameterSetName = 'GetHelp')]
	[Nullable[Int]]$RunEx
)

# Write-Host $PsCmdlet.ParameterSetName


### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
# Das File wird erzeugt
$PathsDFile = "/etc/paths.d/NinjaOne"
# Dieser Pfad wird eingetragen
$PathToAdd = "/Library/Scripts/SSF/NinjaOne/"


# Root nur prüfen, wenn wir die Hilfe nicht abrufen
# Ist irgend ein GetHelp aktiv?
$IsGetHelpActive = (($GetHelp) -or ($GetHelpCls) -or ($GetEx -ne $Null) -or ($RunEx -ne $Null))
If (-Not $IsGetHelpActive) {
	### Root erzwingen
	# 250620 1850
	If ((id -u) -ne 0) {
		Write-Host 'Starte das Script als root'
		If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
			Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
		}	
	
		# Argumente aus den BoundParameters zusammensetzen
		$paramList = @()
		ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
			If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
				$paramList += "-$($kvp.Key)"
			} Else {
				$paramList += "-$($kvp.Key) `"$($kvp.Value)`""
			}
		}
	
		$pwsh = (Get-Command pwsh).Source
	
		If ($paramList.Count -gt 0) {
			# sudo $pwsh $ThisScriptPath @paramList
			$quotedArgs = $paramList -join ' '
			$cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
			sudo bash -c "$cmd"
		} Else {
			# sudo $pwsh $ThisScriptPath
			$cmd = "$pwsh `"$ThisScriptPath`""
			sudo bash -c "$cmd"
		}
		Exit
	}
	
	# Ab hier läuft das Script als root
	Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray
}



### Funcs


# Erzeugt oder aktualisiert die Datei /etc/paths.d/NinjaOne
Function Chack-and-Update-PathsDFile {
	Param (
		[Parameter(Mandatory)]
		[String]$PathsDFile,
		[Parameter(Mandatory)]
		[String]$PathToAdd
	)

	# Prüfen, ob das File existiert
	If (Test-Path $PathsDFile) {
		# Das File existiert bereits
		# Ist der Inhalt korrekt?
		$CurrentContent = Get-Content $PathsDFile -Raw
		If ($CurrentContent.Trim() -eq $PathToAdd.Trim()) {
			Log 1 'Die Datei ist korrekt' -Fore Green
		} Else {
			Log 1 'Der Pfad ist falsch:' -Fore Red
			Log 2 "Ist : $CurrentContent"
			Log 2 "Soll: $PathToAdd"
			Log 1 'Setze den Pfad neu' -Fore Cyan
		}
	} Else {
		Log 1 "Erzeuge: $PathsDFile" -Fore Cyan
	}

	Set-Content -Path $PathsDFile -Value $PathToAdd -NoNewline
	chmod 644 $PathsDFile

	Log 1 'Alles OK' -Fore Green
}



### Prepare

## Script-Pfade auflösen
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
$UnjoinDomain_ps1 = Join-Path $ScriptDir $UnjoinDomain_ps1

# Lib laden
. $TomLibMacOS_ps1 $PSBoundParameters -ParseGetHelp



### Main

# Systemzustand prüfen
Log 0 "Prüfe: $PathsDFile"

Chack-and-Update-PathsDFile -PathsDFile $PathsDFile -PathToAdd $PathToAdd

