#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM, Unix (LF)

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Erzeugt einen neuen MacOS Mobilen Account,
# der als Login für den AD-user genützt wird

# 001, 250707, Tom


Param (
	[Parameter(Mandatory)]
    # Kann Test oder Test@Domain.ch sein,
    # benötigt wird nur Test
	[String]$ADUserName
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)
$ThisScriptPath = $MyInvocation.MyCommand.Definition



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
# Pfad zum createmobileaccount-Tool
$CreateMobileAccountPath = '/System/Library/CoreServices/ManagedClient.app/Contents/Resources/createmobileaccount'


### Root erzwingen
# 250620 1850
If ((id -u) -ne 0) {
    Write-Host 'Starte das Script als root'
	If ([String]::IsNullOrWhiteSpace($ThisScriptPath)) {
		Write-Error 'Variable $ThisScriptPath ist leer. Kann nicht fortfahren.'
	}	

    # Argumente aus den BoundParameters zusammensetzen
    $paramList = @()
    ForEach ($kvp in $PSBoundParameters.GetEnumerator()) {
        If ($kvp.Value -is [switch] -and $kvp.Value.IsPresent) {
            $paramList += "-$($kvp.Key)"
        } Else {
            $paramList += "-$($kvp.Key) `"$($kvp.Value)`""
        }
    }

    $pwsh = (Get-Command pwsh).Source

    If ($paramList.Count -gt 0) {
        # sudo $pwsh $ThisScriptPath @paramList
		$quotedArgs = $paramList -join ' '
		$cmd = "$pwsh `"$ThisScriptPath`" $quotedArgs"
		sudo bash -c "$cmd"
    } Else {
        sudo $pwsh $ThisScriptPath
    }
    Exit
}

# Ab hier läuft das Script als root
Write-Host "`nScript läuft jetzt als root`n`n" -Fore DarkGray


### Funcs


### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters


Log 0 'Erzeuge neuen MacOS Mobilen Account für AD User'

# Prüfen, ob das Tool existiert
if (-not (Test-Path $CreateMobileAccountPath)) {
    Log 4  'Nicht gefunden:' -Fore Red
    Log 5  $CreateMobileAccountPath -Fore Magenta
    Exit 1
}


# Hostnamen bestimmen
# $oHostnamesInfo = Get-HostNames-Info
# Return $oHostnamesInfo

## Params bereinigen
$ADUserName = $ADUserName.Trim()
# Nur den Username ohne Domäne
$ADUserName = $ADUserName.Split('@')[0]



### Main

# Den AD User erzeugen

Log 1 'Wichtig:' -Fore Red
Log 2 'Bei den folgenden Fragen as Login des lokalen Admins eingeben,'
Log 2 'damit der neue Mobile Account auch ein SecureToken bekommt:'
Log 3 'SecureToken admin user name [optional]'

sudo /System/Library/CoreServices/ManagedClient.app/Contents/Resources/createmobileaccount -n "$ADUserName"

# Fragt dann nach dem lokalen Admin Usernamen und Passwort,
# damit der neue Mobile Account auch ein SecureToken bekommt, 
# damit er den FileVault öffnen kann:

# SecureToken admin user name [optional]: 


