#!/bin/zsh
# Format: UTF8, Linux EOL

# Kleines Bash-Script,
# das einen Log-Eintrag hierhin schreibt
# /Users/Shared/NinjaOne/Create-Log.sh.log

# 001, 250610, Tom

## Config

LOG_FILE="/Users/Shared/NinjaOne/Create-Log.sh.log"
SCRIPT_DIR="/Library/Scripts/SSF/NinjaOne"
VERSION_FILE="$SCRIPT_DIR/version.txt"
TEMP_DIR_PREFIX="/tmp/NinjaOne-"
BASE_URL="https://www.akros.ch/it/MacOS"
ZIP_PATTERN="Admin-Scripts-*.zip"


## Funcs

# Logging-Funktion
log() {
    echo "$(date '+%Y-%m-%d %H:%M:%S') - $1" | tee -a "$LOG_FILE"
}


# Init
mkdir -p "$(dirname "$LOG_FILE")"

# Schritt 1: Sicherstellen, dass der Zielordner existiert
log "Checking if script directory exists."

