#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM

#Requires -Version 7

## Suppress PSScriptAnalyzer Warning
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidUsingCmdletAliases', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseApprovedVerbs', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueSwitchParameter', '')]
[Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSAvoidDefaultValueForMandatoryParameter', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSShouldProcess', '')]
# [Diagnostics.CodeAnalysis.SuppressMessageAttribute('PSUseSingularNouns', '')]


# Dient dem Schutz der NinjaOne Custom Fiels, 
# so dass Schädlinge diese nicht verändern oder lesen können
#
# Erhält von der NinjaOne Automatisierung die NinjaOne Rest API Hashes
#
# Liest dann via Rest API die Daten aus dem Custom Field ssfClientTasksData
# und überträgt die Daten in die richtigen Custom Fields


# 001, 250616, Tom


## Test-Daten
#  » In das Custom Field 'SSF Client Tasks Data' eines NinjaOne Computers einfügen
# 
# 
# 250616 1707 SaveFileVaultRecoveryKey
# V001
# RecoveryKey: x1
#
# 250617 170111 SaveFileVaultRecoveryKey
# V001
# RecoveryKey: x2
#
# 250617 1740 Tester
# V001
# Data




[CmdletBinding()]
Param (
	[Parameter(Mandatory)]
	# zB 'Gig.......................M'
	[String]$NinjaOneClientID,
	
	[Parameter(Mandatory)]
	# zB 'aB..................................................1w'	
	[String]$NinjaOneClientSecret,
	
	# Soll nur der $AuthHeader zurückgegeben werden?
	[Switch]$JustGetAuthHeader,
	# Debug?
	[Switch]$Dbg
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)


### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
$FieldName_ssfClientTasksData = 'ssfClientTasksData'

$NinjaOneBaseURL = 'https://eu.ninjarmm.com/'
$NinjaOneBaseURLAPI  = "$($NinjaOneBaseURL.TrimEnd('/'))/api/"

$SetNinjaOneDeviceFieldSecure_ps1 = 'Set-NinjaOne-Device-Field-Secure.ps1'



### Funcs


### Prepare

# Scripts suchen
$SetNinjaOneDeviceFieldSecure_ps1 = Get-ChildItem -LiteralPath $ScriptDir | ? Name -eq $SetNinjaOneDeviceFieldSecure_ps1 | Select -ExpandProperty FullName
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1

# Lib laden
. $TomLibMacOS_ps1 $PSBoundParameters


## Debug
# Print-NinjaOne-AutomaticVars

# Hostnamen laden
$oHostnamesInfo = Get-HostNames-Info
# Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfo


## Authentifizieren
$AuthHeader = Auth-NinjaOne
If ($JustGetAuthHeader) { Return $AuthHeader }


## Die NiniaOneDeviceID bestimmen
$HasNinjaoneDeviceID = -not [String]::IsNullOrWhiteSpace($Env:NINJA_AGENT_NODE_ID)

If($HasNinjaoneDeviceID) {
	$NinjaoneDeviceID = $Env:NINJA_AGENT_NODE_ID
} Else {
	# Die Device-ID aufgrund des Hostnamens suchen
	$ThisDevice = Get-NinjaOne-Device-by-SystemName `
						-AuthHeader $AuthHeader `
						-SystemName $oHostnamesInfo.MacOS_LocalHostNameEffektiv
	
	# Debug
	# Log 4 "$ThisDevice Objekt:" -NewLineBefore
	# $ThisDevice | Out-String | % { Log 5 $_ }
	
	# $ThisDevice.ID
	# $ThisDevice.systemName	
	$NinjaoneDeviceID = $ThisDevice.ID
}


# Haben wir die DeviceID?
If ([String]::IsNullOrWhiteSpace($NinjaoneDeviceID)) {
	Log 4 "2jbb1V Fehler: Device-ID nicht gefunden!" -Fore Red -NewLineBefore
	Log 5 'Abbruch'
	Break Script
}


## Vom Gerät Die Custom Fields lesen
$Fields = Get-NinjaOne-Device-Fields -AuthHeader $AuthHeader `
									-DeviceID $NinjaoneDeviceID `
									-Dbg:$Dbg

# Alle gefundenen Felder ausgeben?
If ($Dbg) {
	Log 4 ("Device ID: {0}" -f $NinjaoneDeviceID) -Fore Green -NewLineBefore
	($Fields | FL | Out-String) -split "`n" | `
		? { -Not [String]::IsNullOrWhiteSpace($_) } | `
		% { Log 5 "  $_" }
}



### Main

# Haben wir Daten in ssfClientTasksData?
$ssfClientTasksData = $Fields.$FieldName_ssfClientTasksData

If ([String]::IsNullOrWhiteSpace($ssfClientTasksData)) {
	Log 4 "Keine Daten in: $FieldName_ssfClientTasksData" -NewLineBefore -Fore Red
	Log 5 'Fertig'
	Break Script	
}
If ($Dbg) { 
	Log 4 '$ssfClientTasksData:' -Fore Magenta
	Log 5 $ssfClientTasksData
}


# Die Elemente in ssfClientTasksData Parsen
If ($Dbg) { Log 4 'Parse Blöcke' -Fore DarkGray }
$oBlöcke = Parse-ClientTasksData -Text $ssfClientTasksData -Dbg:$Dbg
# Return $oBlöcke
If ($Dbg) { 
	Log 4 '$oBlöcke:' -Fore Magenta
	Log 5 ($oBlöcke | Out-String)
}

# Die Elemente verarbeiten
If ($Dbg) { Log 4 'Starte Transfer' -Fore DarkGray }
Transfer-ssfClientTasksData -oBlöcke $oBlöcke `
							-AuthHeader $AuthHeader `
							-DeviceID $NinjaoneDeviceID
	

If ($Dbg) { 
	Log 4 '$oBlöcke nach der Verarbeitung:' -Fore Magenta
	Log 5 ($oBlöcke | Out-String)
}



## Die ssfClientTasksData Daten mit den unverarbeiteten Daten wieder füllen

$oBlöckeUnverarbeitetLines = Get-Block-unprocessed-AsLines `
							-Blocks $oBlöcke `
							-Comment ('{0} Verarbeitungsversuche, failed' -f (Get-Date).ToString('yyMMdd HHmm'))

# Haben wir nicht verarbeitete Elemente?
If ([String]::IsNullOrWhiteSpace($oBlöckeUnverarbeitetLines)) {
	Return
}


# Die nicht verarbeiteten Elemente wieder zurückschreiben
& $SetNinjaOneDeviceFieldSecure_ps1 -DeviceIDs $NinjaoneDeviceID `
	-FieldName $FieldName_ssfClientTasksData `
	-FieldValue $oBlöckeUnverarbeitetLines `
	-Action 'Set' `
	-AuthHeader $AuthHeader

Return 
# Return $oBlöckeUnverarbeitet
# Return $Fields

Break Script

# Haben wir einen Wert?
$WertOri = $Fields.$FieldName_ssfClientTasksData
$WertNeu = ''
Switch ($Action) {
	'Set' {
		$WertNeu = $FieldValue
	}
	'Add' {
		$WertNeu = $WertOri + $FieldValue
	}
	'AddNewLine' {
		$WertNeu = ("{0}`n{1}" -f $WertOri, $FieldValue)
	}
	Default {
		Log 4 "Ungültige Action: $Action" -Fore Red
	}
}

	
# Das Feld setzen
Set-NinjaOne-Device-Field -AuthHeader $AuthHeader -DeviceID $ThisDevice.ID `
						-FieldName $FieldName_ssfClientTasksData -FieldValue $WertNeu -Dbg:$Dbg

