#!/usr/local/bin/pwsh
# !9^9 Nur UTF8 für MacOS, KEIN BOM, Unix (LF)

# Verbindet das MacBook von einer Domäne
# Returns:
#	$True	Domain-Join i.O.
#	$False	Domain-Join nicht i.O.


# 001, 250701, Tom


[CmdletBinding(SupportsShouldProcess, ConfirmImpact = 'Low')]
Param (
    [Parameter(Mandatory, Position = 0)]
	[String]$ZielDomain
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters


$ZielDomain = $ZielDomain.Trim()

$oHostnamesInfo = Get-HostNames-Info
# Print-HostNamesInfo -oHostnamesInfo $oHostnamesInfo



### Main
If ($IsVerbose) { Log 0 'Join-Domain' }

# Sind wir schon Domain-Joined?
If ($oHostnamesInfo.IsDomainJoined) {
	If ($IsVerbose) { Log 1 'MacOS ist Domain-Joined' }

	If ($oHostnamesInfo.DomainJoined -eq $ZielDomain) {
		If ($IsVerbose) { Log 2 "Ist bereits in der Domäne: $ZielDomain"  -Fore Green }
		Return [PSCustomObject]@{
			Resultat = $True
			Message  = "Ist bereits in der Domäne: $ZielDomain"
		}
		
	} Else {
		If ($IsVerbose) { Log 2 "Ist in einer anderen Domäne: $($oHostnamesInfo.DomainJoined)" -Fore Red } 
		Return [PSCustomObject]@{
			Resultat = $False
			Message  = "Ist in einer anderen Domäne: $($oHostnamesInfo.DomainJoined)"
		}
	}

}


## Das Notebook ist nicht Domain-Joined

## Kann das Notebook die Domäne anpingen?

$IsComputerInDomainLAN = Is-Computer-in-Domain-LAN -Domain $ZielDomain

If (-not $IsComputerInDomainLAN) {
	Return [PSCustomObject]@{
		Resultat = $False
		Message  = "Notebook kann die Domäne nicht anpingen: $ZielDomain"
	}
}


## Haben wir Root?
If (Is-Root -eq $False) {
	Return [PSCustomObject]@{
		Resultat = $False
		Message  = 'Script braucht root-Rechte'
	}
}




