#!/usr/local/bin/pwsh

# !9^9 Nur UTF8 für MacOS, KEIN BOM

# Ergänzt ein NinjaOne Textfeld um eine neue Zeile

# 001, 250611, Tom


# !Ex
# /Library/Scripts/SSF/NinjaOne/Add-NinjaOne-TextField-Line.ps1 -FieldName ssfMacOsFileVaultKey -LineToAdd TomTom


[CmdletBinding()]
Param(
	[Parameter(Mandatory)]
	[String]$FieldName,

	[Parameter(Mandatory)]
	[String]$LineToAdd
)



### Init
$ScriptDir = [IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)



### Config
$TomLibMacOS_ps1 = 'TomLib-MacOS.ps1'
$NinjaCliPath = '/Applications/NinjaRMMAgent/programdata/ninjarmm-cli'



### Funcs



### Prepare

# Lib laden
$TomLibMacOS_ps1 = Join-Path $ScriptDir $TomLibMacOS_ps1
. $TomLibMacOS_ps1 $PSBoundParameters



### Main

Write-Verbose "Prüfe, ob das NinjaOne CLI-Tool existiert: '$NinjaCliPath'"
If (-not (Test-Path $NinjaCliPath)) {
	Write-Error "Das NinjaOne CLI-Tool wurde unter '$NinjaCliPath' nicht gefunden"
	Return
}

Write-Verbose "Rufe aktuellen Inhalt des Feldes '$FieldName' ab …"
try {
	# Der Backtick am Zeilenende ist für Multi-Line-Befehle in PowerShell
	# Die `Get-Content` umgeht potentielle Probleme mit der Zeilenumbruchinterpretation
	# bei der direkten Ausgabe in eine Variable.
	$CurrentContent = & "$NinjaCliPath" get "$FieldName" | Out-String | ForEach-Object { $_.Trim() }

	# Behandeln, wenn das Feld (bisher) leer ist. 
	# Out-String kann einen leeren String oder nur Leerzeichen/Zeilenumbrüche zurückgeben.
	If ([string]::IsNullOrWhiteSpace($CurrentContent)) {
		$UpdatedContent = $LineToAdd
	} Else {
		Write-Verbose "Aktueller Inhalt des Feldes '$FieldName':`n$CurrentContent"
		# Füge die neue Zeile mit einem Zeilenumbruch hinzu
		$UpdatedContent = "$CurrentContent`n$LineToAdd"
	}

	Write-Verbose "Setze aktualisierten Inhalt für Feld '$FieldName'..."
	# Verwende die doppelten Anführungszeichen, um sicherzustellen, dass Leerzeichen und Zeilenumbrüche korrekt übergeben werden.
	$cliOutput = & "$NinjaCliPath" set "$FieldName" "$UpdatedContent" 

	if ($LASTEXITCODE -ne 0) {
		Write-Error "Fehler beim Setzen des Feldes '$FieldName'. Exit Code: $LASTEXITCODE. Output: $cliOutput"
	} else {
		Write-Host "Zeile erfolgreich zu Feld '$FieldName' hinzugefügt."
		Write-Verbose "Der aktualisierte Inhalt ist: '$UpdatedContent'"
	}

} catch {
	Write-Error "Ein unerwarteter Fehler ist aufgetreten: $($_.Exception.Message)"
}


