' 005, 150605
' - Files werden neu in \\basdc002\Inventar\Inventarfiles abgelegt
'
' 006, 150608
' Es wird versucht, den Usernamen mittels objComputer.UserName zu bestimmen,
' damit psexec den richtigen User zurück gibt
'
' 007, 150608
' - Positionsunabhängiges Argument <Nummer>: 
'		Definiert, nach wie vielen Tagen erneut ein Inventarfile erzeugt werden soll
'   Beispiel: 
'   GetLocalComputerInventar.vbs 30 
'		» Wenn innert der letzten 30 Tage ein Inventarfile erzeugt wurde,
'			wird jetzt nicht kein neues File erzeugt
'
' - Positionsunabhängiges Argument "-batch": 
'		Am Ende wird nicht auf eine Taste gewartet
'
' - Positionsunabhängiges Argument "-debug":
'		Gibt Debug-Meldungen aus
'
' - Positionsunabhängiges Argument "-open":
'		Öffnet das erzeugte File
' 
' - Positionsunabhängiges Argument "-force":
'		Always create new Inventar-File
' 	
' 008
' 	Aktualisiert
' 	
' 009
' 	Insider Releases erfasst
' 	




Const extension=".csv"
Const delimiter=";"
Const READ=1
Const OVERWRITE=2
Const APPEND=8
Const TrueCryptDetectExe="TrueCryptDetect.exe"
' Const ServerDir = "\\basdc002.akros.ch\Inventar\Inventarfiles\"
Const ServerDir = "\\akros.ch\sysvol\akros.ch\scripts\Inventar\Inventarfiles\"
Dim Header
Header=vbcrlf & "AKROS Inventar-Script" & _
       vbcrlf & "---------------------" & vbcrlf

Dim DEBUGINFO
DEBUGINFO=False

' Anzahl Tage, während dieser kein neues Inventarfile erzeugt wird
' Default: bei jedem Aufruf ein neues File erzeugen
Dim SkipDays
SkipDays=0

Dim Batchmode
Batchmode=False

Dim ForceOpenFile
ForceOpenFile=True

Dim ForceCreateInventar
ForceCreateInventar=True


Dim W10InsiderReleases
W10InsiderReleases = Array("10.0.18362.116", "10.0.18362.113", "10.0.18362.86", "10.0.18362.53", "10.0.17763.167")


forceCScriptExecution

Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objShell = CreateObject("WScript.Shell")

Echo Header

' Prüfe Argumente
For Each strArg in Wscript.Arguments
	If IsNumeric(strArg) Then
		SkipDays=cint(strArg)
		' Echo "SkipDays=" & SkipDays
	End If
	If LCase(strArg) = "-h" or LCase(strArg) = "/h" Then
		ShowUsage()
		Wscript.Quit
	End If
  If StringEndsWith(LCase(strArg), "debug", vbTextCompare) Then
		' Echo "Debug=true"
		DEBUGINFO=true
	End If
  If StringEndsWith(LCase(strArg), "batch", vbTextCompare) Then
		' Echo "Batchmode=true"
		Batchmode=true
	End If
  If StringEndsWith(LCase(strArg), "batchmode", vbTextCompare) Then
		' Echo "Batchmode=true"
		Batchmode=true
	End If
  If StringEndsWith(LCase(strArg), "open", vbTextCompare) Then
		' Echo "ForceOpenFile=true"
		ForceOpenFile=true
	End If
  If StringEndsWith(LCase(strArg), "force", vbTextCompare) Then
		' Echo "Force=true"
		ForceCreateInventar=true
	End If
Next

If ForceCreateInventar = true Then
	SkipDays=-1
End If


Echo "Ich arbeite..."

Set objNet = CreateObject("WScript.NetWork") 

AddTrustedSite "\\akros.ch" 

Dim anzahl
Dim Spalte1(10000)
Dim Spalte2(10000)
Dim Spalte3(10000)
Dim Spalte4(10000)
Dim NextKeyValuItem
NextKeyValuItem = 0

strComputer = "."
strRegComputerName = "HKLM\SYSTEM\CurrentControlSet\Control\ComputerName\ComputerName\ComputerName"
' strComputerName = objShell.RegRead(strRegComputerName)
strUserName = objNet.UserName

AddKeyValue "Type", "Key", "Value1", "Value2"

Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
Call GetWin32_ComputerSystemInfo()

' Alter des jüngsten Inventarfiles berechnen
JuengstesInventarFile = GetAgeOfNewestInventarFile()
Debug ("Juengstes Inventar: " & JuengstesInventarFile & " Tage")

' Müssen wir ein Inventar ausführen?
If JuengstesInventarFile <= SkipDays Then
	Wscript.Echo "Das Inventar ist bereits aktuell genug!, besten Dank."
	Wscript.Quit
Else
	Debug ("Das Inventar ist zu alt und muss neu erstellt werden.")
End If



' Start: Inventar zusammenstellen
Call SetWorkingDir(ServerDir)


' HW
Echo "- Sammle Win32_ComputerSystemProduct"
ComputerSystemProduct=1
Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_ComputerSystemProduct") 
For Each objItem in colItems 
	AddKeyValue "CSP", ComputerSystemProduct, " Caption", objItem.Caption
	AddKeyValue "CSP", ComputerSystemProduct, " Description", objItem.Description
	AddKeyValue "CSP", ComputerSystemProduct, " Serial Number", objItem.IdentifyingNumber
	AddKeyValue "CSP", ComputerSystemProduct, " Name", objItem.Name
	AddKeyValue "CSP", ComputerSystemProduct, " SKUNumber", objItem.SKUNumber
	AddKeyValue "CSP", ComputerSystemProduct, " UUID", objItem.UUID
	AddKeyValue "CSP", ComputerSystemProduct, " Vendor", objItem.Vendor
	AddKeyValue "CSP", ComputerSystemProduct, " Version", objItem.Version
	ComputerSystemProduct=ComputerSystemProduct+1
Next

'Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_Process", "WQL")
'For Each objItem In colItems
'	' WScript.Echo "CommandLine: " & objItem.CommandLine
'	'If InStr(LCase(objItem.ExecutablePath),"java") > 0 Then
'		' WScript.Echo "ExecutablePath: " & objItem.ExecutablePath
'	'End If
'	' WScript.Echo
'Next


' OS
Echo "- Sammle Win32_OperatingSystem"
Set colSettings = objWMIService.ExecQuery ("Select * from Win32_OperatingSystem")
For Each objOperatingSystem in colSettings 
	' AddKeyValue "OS", "OS", objOperatingSystem.Name, ""
	OSInfo=Split(objOperatingSystem.Name, "|")
	AddKeyValue "OS", "OS", OSInfo(0), OSInfo(1) + ", " + OSInfo(2)

	AddKeyValue "OS", "Version", objOperatingSystem.Version, ""
	
	If IsW10InsiderRelease(W10InsiderReleases, objOperatingSystem.Version) Then
		AddKeyValue "OS", "IsInsider", "Ja", ""
	Else
		AddKeyValue "OS", "IsInsider", "Nein", ""
	End If
	
	AddKeyValue "OS", "Installation Date", getmydat(objOperatingSystem.InstallDate), ""
	AddKeyValue "OS", "Servicepack", objOperatingSystem.ServicePackMajorVersion & "." & objOperatingSystem.ServicePackMinorVersion, ""
	AddKeyValue "OS", "Manufacturer", objOperatingSystem.Manufacturer, ""
	AddKeyValue "OS", "WindowsDirectory", objOperatingSystem.WindowsDirectory, ""
	AddKeyValue "OS", "Locale", PrintSprache(objOperatingSystem.Locale), ""
	AddKeyValue "OS", "Available Physical Memory", ConvertSize(objOperatingSystem.FreePhysicalMemory * 1024), ""
	AddKeyValue "OS", "Total Virtual Memory", ConvertSize(objOperatingSystem.TotalVirtualMemorySize * 1024), ""
	AddKeyValue "OS", "Available Virtual Memory", ConvertSize(objOperatingSystem.FreeVirtualMemory * 1024), ""
	AddKeyValue "OS", "Size stored in paging files", ConvertSize(objOperatingSystem.SizeStoredInPagingFiles * 1024), ""
	Exit For
Next


' CPU
Echo "- Sammle Win32_Processor"
Set colSettings = objWMIService.ExecQuery ("Select * from Win32_Processor")
For Each objProcessor in colSettings 
	AddKeyValue "CPU", "Manufacturer", objProcessor.Manufacturer, ""
	AddKeyValue "CPU", "System Type", GetCPUArchitecture(objProcessor.Architecture), ""
	AddKeyValue "CPU", "Description", objProcessor.Description, ""
	AddKeyValue "CPU", "Max Speed", ConvertFrequency(objProcessor.MaxClockSpeed), ""
	AddKeyValue "CPU", "No. of Cores", objProcessor.NumberOfCores, ""
	AddKeyValue "CPU", "No. of Logical Processors", objProcessor.NumberOfLogicalProcessors, ""
	AddKeyValue "CPU", "Name", objProcessor.Name, ""

	'WScript.Echo objProcessor.AddressWidth
	'WScript.Echo objProcessor.Architecture
	'WScript.Echo objProcessor.Availability
	'WScript.Echo objProcessor.Caption
	'WScript.Echo objProcessor.ConfigManagerErrorCode
	'WScript.Echo objProcessor.ConfigManagerUserConfig
	'WScript.Echo objProcessor.CpuStatus
	'WScript.Echo objProcessor.CreationClassName
	'WScript.Echo objProcessor.CurrentClockSpeed
	'WScript.Echo objProcessor.CurrentVoltage
	'WScript.Echo objProcessor.DataWidth
	'WScript.Echo objProcessor.Description
	'WScript.Echo objProcessor.DeviceID
	'WScript.Echo objProcessor.ErrorCleared
	'WScript.Echo objProcessor.ErrorDescription
	'WScript.Echo objProcessor.ExtClock
	'WScript.Echo objProcessor.Family
	'WScript.Echo objProcessor.InstallDate
	'WScript.Echo objProcessor.L2CacheSize
	'WScript.Echo objProcessor.L2CacheSpeed
	'WScript.Echo objProcessor.L3CacheSize
	'WScript.Echo objProcessor.L3CacheSpeed
	'WScript.Echo objProcessor.LastErrorCode
	'WScript.Echo objProcessor.Level
	'WScript.Echo objProcessor.LoadPercentage
	'WScript.Echo objProcessor.Manufacturer
	'WScript.Echo objProcessor.MaxClockSpeed
	'WScript.Echo objProcessor.NumberOfCores
	'WScript.Echo objProcessor.NumberOfLogicalProcessors
	'WScript.Echo objProcessor.OtherFamilyDescription
	'WScript.Echo objProcessor.PNPDeviceID
	'WScript.Echo objProcessor.PowerManagementSupported
	'WScript.Echo objProcessor.ProcessorId
	'WScript.Echo objProcessor.ProcessorType
	'WScript.Echo objProcessor.Revision
	'WScript.Echo objProcessor.Role
	'WScript.Echo objProcessor.SocketDesignation
	'WScript.Echo objProcessor.Status
	'WScript.Echo objProcessor.StatusInfo
	'WScript.Echo objProcessor.Stepping
	'WScript.Echo objProcessor.SystemCreationClassName
	'WScript.Echo objProcessor.SystemName
	'WScript.Echo objProcessor.UniqueId
	'WScript.Echo objProcessor.UpgradeMethod
	'WScript.Echo objProcessor.Version
	'WScript.Echo objProcessor.VoltageCaps
	Exit For
Next


' BIOS
Echo "- Sammle Win32_BIOS"
Set colSettings = objWMIService.ExecQuery ("Select * from Win32_BIOS")
For Each objBIOS in colSettings 
	AddKeyValue "BIOS", "Version", objBIOS.Version, ""
	AddKeyValue "BIOS", "Build Number", objBIOS.BuildNumber, ""
    AddKeyValue "BIOS", "Manufacturer", objBIOS.Manufacturer, ""
    AddKeyValue "BIOS", "Name", objBIOS.Name, ""
    AddKeyValue "BIOS", "Release Date", objBIOS.ReleaseDate, ""
    AddKeyValue "BIOS", "Status", objBIOS.Status, ""
    AddKeyValue "BIOS", "Version", objBIOS.Version, ""
    AddKeyValue "SMBIOS", "Version", objBIOS.SMBIOSBIOSVersion, ""
    AddKeyValue "SMBIOS", "Major Version", objBIOS.SMBIOSMajorVersion, ""
    AddKeyValue "SMBIOS", "Minor Version", objBIOS.SMBIOSMinorVersion, ""
    AddKeyValue "SMBIOS", "Present", objBIOS.SMBIOSPresent, ""
	Exit For
Next


'SET drives = Get-WmiObject -ComputerName $computer Win32_LogicalDisk | Where-Object {$_.DriveType -eq 3}
'Set drives = objWMIService.ExecQuery ("Select * from Win32_LogicalDisk")
'For Each drive in drives'
'	Values(21) = objBIOS.Version
'Next


' Software
Echo "Erzeuge Inventarliste - kann eine Minute dauern!"
On Error Resume Next
Err.Clear
OfficeLanguage = GetOfficeLanguage()
	If Err.Number <> 0 Then
		AddKeyValue "Office", "Language", "Unbekannt Sprache!", ""
	Else
		AddKeyValue "Office", "Language", OfficeLanguage, ""
  End If


On Error Resume Next
Err.Clear
Call GetSoftware("", True)
Call CheckAndClearError()


' Disks
DiskNr=1
Set colItems = objWMIService.ExecQuery("Select * from Win32_LogicalDisk WHERE DriveType=3",,48)
For Each objItem in colItems
	AddKeyValue "Disk", DiskNr, "DeviceID", objItem.DeviceID
	AddKeyValue "Disk", DiskNr, "TrueCrypt" & objItem.DeviceID, IstrueCrypted(objItem.DeviceID)
	AddKeyValue "Disk", DiskNr, "Description", objItem.Description
	AddKeyValue "Disk", DiskNr, "FileSystem", objItem.FileSystem
	AddKeyValue "Disk", DiskNr, "Size", ConvertSize(objItem.Size)
	AddKeyValue "Disk", DiskNr, "FreeSpace", ConvertSize(objItem.FreeSpace)
	AddKeyValue "Disk", DiskNr, "VolumeName", objItem.VolumeName
	AddKeyValue "Disk", DiskNr, "VolumeSerialNumber", objItem.VolumeSerialNumber
	DiskNr = DiskNr + 1
Next
Call CheckAndClearError()

AddKeyValue "IE", "Internet Explorer", GetIE, ""


' Datei erzeugen und per E-Mail senden
csvFileToSend = CreateFile_Vertikal()
Debug ("csvFileToSend:" & csvFileToSend)
Echo ""

Dim FileMustBeManuallySent
FileMustBeManuallySent = True
If PathIsOnNetwork(csvFileToSend) Then
	' File ist bereits am richtigen Ort gespeichert
	FileMustBeManuallySent = false
Else
	'If SendMail(strUserName, csvFileToSend) = True Then
	'	' Alles OK
	'	FileMustBeManuallySent = false
	'End If
End If


If FileMustBeManuallySent = False Then
	Wscript.Echo "Die Hardware-Informationen wurden erfolgreich erfasst und uebermittelt." & vbcrlf & vbcrlf & _
				 "Vielen Dank!"
Else
	ForceOpenFile = False
	Call OpenExcel(csvFileToSend)
	
	Wscript.Echo "Die Hardware-Informationen konnten nicht automatisch versendet werden." & vbcrlf & vbcrlf & _
				 "Bitte die geöffnete Excel-Datei an it@akros.ch senden." & vbcrlf & vbcrlf & _
				 "Vielen Dank!"
End If

If ForceOpenFile=true Then
	Call OpenExcel(csvFileToSend)
End If

'Wscript.Echo "Keys  :" & Print(Keys, UBound(Keys), delimiter)
'Wscript.Echo "Values:" & Print(Values, UBound(Keys), delimiter)

Call Debug(vbcrlf & "Debug:")
Call Debug(DebugPrint (Spalte1, Spalte2, Spalte3, Spalte4))

Echo ""
Call Done()

WScript.Quit


Function PrintSprache(Locale)
	Select Case LCase(Locale)
		Case "0807" PrintSprache="Deutsch (Schweiz)"
		Case Else PrintSprache=Locale
	End Select 
End Function



Function ConvertSize(Size) 
	Suffix = "Bytes" 
	If Size >= 1024 Then suffix = "KB" 
	If Size >= 1048576 Then suffix = "MB" 
	If Size >= 1073741824 Then suffix = "GB" 
	If Size >= 1099511627776 Then suffix = "TB" 

	Select Case Suffix 
		Case "KB" Size = Round(Size / 1024, 1) 
		Case "MB" Size = Round(Size / 1048576, 1) 
		Case "GB" Size = Round(Size / 1073741824, 1) 
		Case "TB" Size = Round(Size / 1099511627776, 1) 
	End Select 

	ConvertSize = Size & Suffix 
End Function

' Speed in MHz
Function ConvertFrequency(speed) 
	Suffix = "MHz" 
	If speed >= 1024 Then suffix = "GHz" 

	Select Case Suffix 
		Case "GHz" speed = Round(speed / 1024, 1) 
	End Select 

	ConvertFrequency = speed & Suffix 
End Function


Function Print(array, max, delimiter)
	Dim res
	res = ""
	Dim i
	For i = 0 To max
		If Len(Res)>0 Then Res = Res & delimiter
		Res = Res & array(i)
	Next
	Print = Res
End Function


Function DebugPrint(aSpalte1, aSpalte2, aSpalte3, aSpalte4)
	Dim Res
	Res = ""
	For i = 0 To UBound(aSpalte1)
		If Len(Trim(Spalte1(i)))>0 Then
			Res = Res & Spalte1(i) & ": " & Spalte2(i) & ", " & Spalte3(i) & ", " & Spalte4(i) & vbcrlf
		End If
	Next
	DebugPrint = Res
End Function

Function GetCPUArchitecture(architecture)
	Select Case LCase(architecture)
		Case 0 GetCPUArchitecture = "x86"
		Case 1 GetCPUArchitecture = "MIPS"
		Case 2 GetCPUArchitecture = "Alpha"
		Case 3 GetCPUArchitecture = "PowerPC"
		Case 5 GetCPUArchitecture = "ARM"
		Case 6 GetCPUArchitecture = "Itanium"
		Case 9 GetCPUArchitecture = "x64"
	End Select 
End Function


Function GetIE()
	file = "C:\Program Files\Internet Explorer\iexplore.exe"
	GetIE = objFSO.GetFileVersion(file) 
End Function


Function Test

	' Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\CIMV2")
	Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_Process", "WQL")

	For Each objItem In colItems
		WScript.Echo "CommandLine: " & objItem.CommandLine
		WScript.Echo "ExecutablePath: " & objItem.ExecutablePath
		WScript.Echo
	Next

End Function


Function IstrueCrypted(drive)

	If NOT HasSoftwareInstalled("Truecrypt") Then
		IstrueCrypted = False
		Exit Function
	End If

	Dim Errorlevel
	If HasLocalTrueCryptCheck Then
		Errorlevel = CallExternal(CurDir & TrueCryptDetectExe & " /istcvolume " & drive, 0, true)
	Else
		Errorlevel = CallExternal(ServerDir & TrueCryptDetectExe & " /istcvolume " & drive, 0, true)
	End If
	
	If Errorlevel=0 Then
		IstrueCrypted = False
	Else
		IstrueCrypted = True
	End If
End Function

' windowstate=0 = Hidden
' 1 = Activates and displays a window
Function CallExternal(cmd, windowstate, wait) 
	Set WshShell = WScript.CreateObject("WScript.Shell")
	CallExternal = WshShell.Run(cmd, windowstate, wait)
End Function



Function AddTrustedSite(strDomainName) 
    Set WshShell = Wscript.CreateObject("Wscript.Shell") 
    strRegKey = "HKCU\Software\Microsoft\Windows\CurrentVersion\Internet Settings\ZoneMap\Domains\" 
    WshShell.RegWrite strRegKey & strDomainName & "\", "", "REG_SZ" 
    WshShell.RegWrite strRegKey & strDomainName & "\*", "1", "REG_DWORD" 
End Function


Function HasSoftwareInstalled(Software)
	sSoftware = Print(Spalte1, NextKeyValuItem, delimiter)
	If InStr(LCase(sSoftware), LCase(Software)) > 0 Then
		HasSoftwareInstalled = True
	Else
		HasSoftwareInstalled = False
	End If
End Function

Function CreateFile_Horizontal
	Dim sKeys, sValues
	sKeys = Print(Spalte1, NextKeyValuItem, delimiter)
	sValues = Print(Spalte2, NextKeyValuItem, delimiter)

	dtmNow = Now
	strNow = Right(Year(dtmNow),2) & Right("0" & Month(dtmNow), 2) & Right("0" & Day(dtmNow), 2) & _
			 "_" & Right("0" & Hour(dtmNow), 2) & Right("0" & Minute(dtmNow), 2) & Right ("0" & Second(dtmNow), 2)
	strFileOut = CurDir & GetFileNamePrefix() & " - " & strNow & extension
	
	' File zurückgeben
	CreateFile_Horizontal = strFileOut
	
	If objFSO.FileExists(strFileOut) Then
		'Set objFileOut = objFSO.OpenTextFile(strFileOut, APPEND)
		'objFileOut.WriteLine("")
    Set objFileOut = objFSO.OpenTextFile(strFileOut, OVERWRITE)
	Else
    Set objFileOut = objFSO.CreateTextFile(strFileOut)
	End If

  objFileOut.WriteLine(sKeys)
  objFileOut.WriteLine(sValues)
  objFileOut.Close()

	'objReg.EnumKey HKLM, strRegIdentityCode, arrIdentityCode
	'For Each strIdentityCode In arrIdentityCode
    '  strLine = fncRegKeyValue("HKLM", strRegIdentityCode & "\" & strIdentityCode, arrRegKey)
    '  If strLine <> "" Then
    '     objFileOut.WriteLine(strComputerName & vbTab & strIdentityCode & strLine)
    '  End If
	'Next
	
End Function


Function GetFileNamePrefix()
	GetFileNamePrefix = strUserName & " - " & objNet.ComputerName
End Function


Function GetFileName()

End Function


Function CreateFile_Vertikal

	dtmNow = Now
	strNow = Right(Year(dtmNow),2) & Right("0" & Month(dtmNow), 2) & Right("0" & Day(dtmNow), 2) & _
			 "_" & Right("0" & Hour(dtmNow), 2) & Right("0" & Minute(dtmNow), 2) & Right ("0" & Second(dtmNow), 2)
	strFileOut = CurDir & GetFileNamePrefix() & " - " & strNow & extension

	' Filenamen zurückgeben
	CreateFile_Vertikal = strFileOut
	
	If objFSO.FileExists(strFileOut) Then
      'Set objFileOut = objFSO.OpenTextFile(strFileOut, APPEND)
      'objFileOut.WriteLine("")
      Set objFileOut = objFSO.OpenTextFile(strFileOut, OVERWRITE)
	Else
      Set objFileOut = objFSO.CreateTextFile(strFileOut)
	End If

	For i = 0 to NextKeyValuItem
	    objFileOut.WriteLine(Spalte1(i) & delimiter & Spalte2(i) & delimiter & Spalte3(i) & delimiter & Spalte4(i))
	Next

  objFileOut.Close()

	'objReg.EnumKey HKLM, strRegIdentityCode, arrIdentityCode
	'For Each strIdentityCode In arrIdentityCode
    '  strLine = fncRegKeyValue("HKLM", strRegIdentityCode & "\" & strIdentityCode, arrRegKey)
    '  If strLine <> "" Then
    '     objFileOut.WriteLine(strComputerName & vbTab & strIdentityCode & strLine)
    '  End If
	'Next
	
End Function

Function GetUserName_001(ByVal InputString)
  Dim Result
  If InStr(InputString, "\") > 0 Then
    Result = Split(InputString, "\")(1)
  Else
    Result = InputString
  End If
  GetUserName_001 = Result
End Function

'Function AddKeyValue_(Key, Value)
'	Keys(NextKeyValuItem) = Key
'	Values(NextKeyValuItem) = Value
'	NextKeyValuItem = NextKeyValuItem + 1
'End Function

Function AddKeyValue(aSpalte1, aSpalte2, aSpalte3, aSpalte4)
	Spalte1(NextKeyValuItem) = aSpalte1
	Spalte2(NextKeyValuItem) = aSpalte2
	Spalte3(NextKeyValuItem) = aSpalte3
	Spalte4(NextKeyValuItem) = aSpalte4
	NextKeyValuItem = NextKeyValuItem + 1
End Function

Function SendMail(subject, filename)

  Echo "Sende die E-Mail mit dem Inventar..."

	Dim ObjSendMail
	Set ObjSendMail = CreateObject("CDO.Message") 
		 
	'This section provides the configuration information for the remote SMTP server.
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2 'Send the message using the network (SMTP over the network).
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpserver") ="mail.jig.ch"
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 465 ' or 587
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpusessl") = True
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout") = 60
		 
	' Google apps mail servers require outgoing authentication. Use a valid email address and password registered with Google Apps.
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1 'basic (clear-text) authentication
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendusername") ="akroslog@jig.ch"
	ObjSendMail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendpassword") ="Kaj5Bo0Quoz.Thel4"
		 
	ObjSendMail.Configuration.Fields.Update
		 
	ObjSendMail.To = "it@akros.ch"
	ObjSendMail.Subject = "Inventar von: " & subject
	ObjSendMail.From = "akroslog@jig.ch"
	ObjSendMail.AddAttachment filename
	'ObjSendMail.HTMLBody = "this is the body"
	ObjSendMail.TextBody = "Rechner-Informationen fuer "  & _
						   objNet.ComputerName & " / " & strUserName

  On Error Resume Next
	ObjSendMail.Send
	If Err.Number <> 0 Then
    Echo "Fehler beim E-Mail-Versand!"
		SendMail=False
	Else
    Echo "E-Mail erfolgreich verschickt."
		SendMail=True
  End If

  On Error Goto 0
	
	Set ObjSendMail = Nothing 
End Function


Function CurDir()
	CurDir = AddBackSlash(CreateObject("Scripting.FileSystemObject").GetAbsolutePathName("."))
End Function

Function SetWorkingDir(dir)
	On Error resume next
	objShell.CurrentDirectory = dir
	On Error goto 0
End Function

Function WorkingOnNetwork()
	If Left(CurDir,1) = "\" Then
		WorkingOnNetwork = True
	Else
		WorkingOnNetwork = False
	End If
End Function

Function PathIsOnNetwork(file)
	If Left(file,1) = "\" Then
		PathIsOnNetwork = True
	Else
		PathIsOnNetwork = False
	End If
End Function

Function AddBackSlash(item)
  If Right(item, 1) = "\" Then
	AddBackSlash=item
  Else
	AddBackSlash=item & "\"
  End If
End Function

Function OpenExcel(file)
	Call Debug ("OpenExcel:" & file)
	Dim objXl 
	Dim objWb
	Set objXl = CreateObject("EXCEL.APPLICATION")
	With objXl
		.Workbooks.Open file
		.Application.DisplayAlerts = False
		.Sheets(1).Columns("A").TextToColumns .Range("A1"), 1, , , , True  'semicolon-delimited
		.Sheets(1).UsedRange.EntireColumn.Autofit()
		.Application.DisplayAlerts = True
	End With	
	
	objXl.Application.Visible = True
End Function


Function GetSoftware(filter, UseUninstall)

	Dim Res
	Res = ""

	On Error Resume Next
	Const HKEY_CURRENT_USER = &H80000001
	Const HKEY_LOCAL_MACHINE = &H80000002
	Const REG_SZ = 1
	Const REG_EXPAND_SZ = 2
	Const REG_BINARY = 3
	Const REG_DWORD = 4
	Const REG_MULTI_SZ = 7

	dtmStart = Timer
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
	Set colProducts = objWMIService.ExecQuery("SELECT Caption,Description,InstallDate,InstallLocation,InstallState,Name,Vendor,Version FROM Win32_Product")
	For Each objProduct in colProducts
		If UseUninstall = False AND Err.Number = 0 Then
			If filter <> "" Then
				If InStr(UCase(objProduct.Name),UCase(filter)) Then 
					'If Len(Res)>0 Then Res = Res & delimiter
					'Res = Res & objProduct.Name & "(" & objProduct.Version & ")"
					AddKeyValue "SW", objProduct.Name, objProduct.Version, ""
			 
					'Wscript.Echo "Caption=" & objProduct.Caption
					'Wscript.Echo "Description=" & objProduct.Description
					'Wscript.Echo "InstallDate=" & objProduct.InstallDate
					'Wscript.Echo "InstallLocation=" & objProduct.InstallLocation
					'Wscript.Echo "InstallState=" & objProduct.InstallState
					'Wscript.Echo "Name=" & objProduct.Name
					'Wscript.Echo "Vendor=" & objProduct.Vendor
					'Wscript.Echo "Version=" & objProduct.Version & vbCrLf
				End If
			Else
				'If Len(Res)>0 Then Res = Res & delimiter
				'Res = Res & objProduct.Name & "(" & objProduct.Version & ")"
				AddKeyValue "SW", objProduct.Name, objProduct.Version, ""
			End If
		Else
			hDefKey = HKEY_LOCAL_MACHINE
			strKeyPath = "Software\Microsoft\Windows\CurrentVersion\Uninstall"
			Set objReg = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")
			objReg.EnumKey hDefKey, strKeyPath, arrSubKeys

			For Each strSubkey In arrSubKeys
				Call ClearError()
			
				' AddKeyValue "NEW SW", "****************************************************************"

				strSubKeyPath = strKeyPath & "\" & strSubkey
				objReg.EnumValues hDefKey, strSubKeyPath, arrValueNames, arrTypes
				
				sDisplayName = ""
				sDisplayVersion = ""
				sInstallDate = ""
				sPublisher = ""
				
				For i = LBound(arrValueNames) To UBound(arrValueNames)

					strValueName = arrValueNames(i)
					
					If arrTypes(i) = REG_SZ Then
						objReg.GetStringValue hDefKey, strSubKeyPath, strValueName, strValue
						'If Len(Res)>0 Then Res = Res & delimiter
						'Res = Res & strValueName & " = " & strValue
						' Echo "*** REG_SZ:" & strValueName & "/" & strValue
					ElseIf arrTypes(i) = REG_EXPAND_SZ Then
						objReg.GetExpandedStringValue hDefKey, strSubKeyPath, strValueName, strValue
						' Echo "*** REG_EXPAND_SZ:" & strValueName & "/" & strValue
					ElseIf arrTypes(i) = REG_DWORD Then
						objReg.GetDWORDValue hDefKey, strSubKeyPath, strValueName, strValue
						' Echo "*** DWORD:" & strValueName & "/" & strValue
					Else
						Call Debug("*** UnknownType:" & arrTypes(i) & ":" & strValueName & "/" & strValue)
					End If

					' AddKeyValue "SW: " & strValueName, strValue

					If strValueName = "DisplayName" Then sDisplayName = strValue
					If strValueName = "DisplayVersion" Then sDisplayVersion = strValue
					If strValueName = "InstallDate" Then sInstallDate = strValue
					If strValueName = "Publisher" Then sPublisher = strValue
					
				Next
				
				If Trim(sDisplayName) <> "" OR Trim(sPublisher) <> "" Then
					If Trim(sDisplayVersion) = "" Then sDisplayVersion = "-"
					AddKeyValue "SW", sDisplayName, sPublisher, sDisplayVersion
				End If

			Next
			Exit Function
		End If
	Next
	
	' GetJavaVersion=Res

End Function

Function Get_REG_MULTI_SZ_Value(valRegVal, delimiter)
    dim Res
	Res = ""
	For i = 0 To UBound( valRegVal )
		If Len(valRegVal(i)) > 0 Then
			If Len(Res)>0 Then Res = Res & delimiter
			Res = Res & valRegVal(i)
		End If
    Next
	Get_REG_MULTI_SZ_Value = Res
End Function


Function HasLocalTrueCryptCheck()
	If objFSO.FileExists(CurDir & TrueCryptDetectExe) Then
		HasLocalTrueCryptCheck=true
	Else
		HasLocalTrueCryptCheck=false
	End If
End Function

Function getmydat(wmitime)
	Set dtmInstallDate = CreateObject("WbemScripting.SWbemDateTime")
	dtmInstallDate.Value = wmitime
	getmydat = dtmInstallDate.GetVarDate
End function


Sub forceCScriptExecution
    Dim Arg, Str
    If Not LCase( Right( WScript.FullName, 12 ) ) = "\cscript.exe" Then
        For Each Arg In WScript.Arguments
            If InStr( Arg, " " ) Then Arg = """" & Arg & """"
            Str = Str & " " & Arg
        Next
        CreateObject( "WScript.Shell" ).Run _
            "cscript //nologo """ & _
            WScript.ScriptFullName & _
            """ " & Str
        WScript.Quit
    End If
End Sub

Function Echo(txt)
	WScript.Echo txt
End Function

Function Done()
	If Batchmode=true Then Exit Function
	Wscript.StdOut.Write "Weiter mit <ENTER>"
	Do While Not WScript.StdIn.AtEndOfLine
	   Input = WScript.StdIn.Read(1)
	Loop
End Function

Function GetAgeOfNewestInventarFile()

  If Not FolderExists(ServerDir) Then
    GetAgeOfNewestInventarFile = 9999
    Exit Function
  End If

	SuchStr = GetFileNamePrefix()
	' WScript.Echo SuchStr
	AlterJuengstesFile = 9999
	For Each objFile In objFSO.GetFolder(ServerDir).Files
		' WScript.Echo objFile.Name
		If StringEndsWith(objFile.Name, extension, vbTextCompare) Then
			' Passendes Inventarfile gefunden
			If InStr(objFile.Name, SuchStr) = 1  Then
				' WScript.Echo objFile.Name
				' Wscript.Echo objFile.DateCreated
				Alter = DateDiff("d", objFile.DateCreated, Now)
				' WScript.Echo Alter
				If AlterJuengstesFile > Alter Then
					AlterJuengstesFile = Alter
				End If
				' Wscript.Quit
			End If
		End If
	Next
	GetAgeOfNewestInventarFile = cint(AlterJuengstesFile)
End Function


Public Function StringEndsWith(strValue, CheckFor, CompareType)
	' Determines if a string ends with the same characters as CheckFor string
	' True if end with CheckFor, false otherwise

	'Case sensitive by default.  If you want non-case sensitive, set
	'last parameter to vbTextCompare
 
  'Examples 
  'MsgBox StringEndsWith("Test", "ST") 'False
  'MsgBox StringEndsWith("Test", "ST", vbTextCompare) 'True

  Dim sCompare
  Dim lLen
   
  lLen = Len(CheckFor)
  If lLen > Len(strValue) Then Exit Function
  sCompare = Right(strValue, lLen)
  StringEndsWith = StrComp(sCompare, CheckFor, CompareType) = 0

End Function

Function Debug(str)
	If DEBUGINFO Then Wscript.Echo str
End Function

Function FolderExists(aFolder)
  FolderExists = objFSO.FolderExists(aFolder)
End Function


Function ShowUsage()
	Echo "Argumentliste:"
	Echo "Argument <Zahl>: Anzahl Tage, waehrend dieser kein neues Inventarfile erzeugt wird."
	Echo "                 -1: Inventar immer erzeugen."
	Echo "Argument -Batch | -Batchmode: Aktiviert den Batchmode: am Ende wird nicht auf <ENTER> gewartet"
	Echo "Argument -Debug: Aktiviert den Debug-Mode"
	Echo "Argument -Open : Öffnet das erzeugte File"
	Echo "Argument -force: Immer neues Inventar-File erzeugen"
End Function

Function GetWin32_ComputerSystemInfo()
	Echo "- Sammle Win32_ComputerSystem"
	Set colSettings = objWMIService.ExecQuery ("Select * from Win32_ComputerSystem")
	For Each objComputer in colSettings 
		' SYS;UserName;AKROS\username;
		AddKeyValue "SYS", "UserName", objComputer.UserName, ""
		
		if LCase(strUserName) = "administrator" Then
			strUserName = GetUserName_001(objComputer.UserName)
		End if
		
		AddKeyValue "SYS", "System Name", objComputer.Name, ""
		AddKeyValue "SYS", "System Manufacturer", objComputer.Manufacturer, ""
		AddKeyValue "SYS", "System Model", objComputer.Model, ""
		AddKeyValue "SYS", "Total Physical Memory", ConvertSize(objComputer.TotalPhysicalMemory), ""
		AddKeyValue "SYS", "DNSHostName", objComputer.DNSHostName, ""
		AddKeyValue "SYS", "Domain", objComputer.Domain, ""
		AddKeyValue "SYS", "NumberOfLogicalProcessors", objComputer.NumberOfLogicalProcessors, ""
		AddKeyValue "SYS", "PartOfDomain", objComputer.PartOfDomain, ""
		AddKeyValue "SYS", "Workgroup", objComputer.Workgroup, ""
		' strUserName = objComputer.UserName
		Exit For
	Next
End Function


Function CheckAndClearError()
	If Err.Number <> 0 Then
    WScript.Echo "Error: " & Err.Number
    WScript.Echo "Source: " &  Err.Source
    WScript.Echo "Description: " &  Err.Description
    Err.Clear
	End If
End Function

Function ClearError()
	If Err.Number <> 0 Then
    Err.Clear
	End If
End Function

Function GetOfficeLanguage()
	Set objWord = CreateObject("Word.Application")
	msoLanguageIDUI = 2
	languageID = objWord.Application.LanguageSettings.LanguageID(msoLanguageIDUI)
	Select Case languageID
		Case 1029
			GetOfficeLanguage = "Czech"
		Case 1030
			GetOfficeLanguage = "Danish"
		Case 1031
			GetOfficeLanguage = "German"
		Case 1032
			GetOfficeLanguage = "Greek"
		Case 1033
			GetOfficeLanguage = "English"
		Case 1034
			GetOfficeLanguage = "Spanish"
		Case 1035
			GetOfficeLanguage = "Finnish"
		Case 1036
			GetOfficeLanguage = "French"
		Case 1038
			GetOfficeLanguage = "Hungarian"
		Case 1040
			GetOfficeLanguage = "Italian"
		Case 1043
			GetOfficeLanguage = "Dutch"
		Case 1044
			GetOfficeLanguage = "Norwegian"
		Case 1045
			GetOfficeLanguage = "Polisch"
		Case 1046
			GetOfficeLanguage = "Portuguese - Brazilian"
		Case 1049
			GetOfficeLanguage = "Russian"
		Case 1053
			GetOfficeLanguage = "Swedish"
		Case 1055
			GetOfficeLanguage = "Turkish"
		Case 2070
			GetOfficeLanguage = "Portuguese"
		Case Else
			GetOfficeLanguage = languageID
	End Select
	Set objWord = Nothing 
End Function


Function IsW10InsiderRelease(W10InsiderReleases, CurrentRelease)
	For j=Lbound(W10InsiderReleases) to Ubound(W10InsiderReleases)
		' If InStr(W10InsiderReleases(j), CurrentRelease) <> 0 Then
		If StrComp(W10InsiderReleases(j), CurrentRelease) = 0 Then
			IsW10InsiderRelease = True
			Exit Function
		End If
	Next
	IsW10InsiderRelease = False
End Function

