﻿# Lädt von 
# https://github.com/microsoft/winget-cli/releases
# das neuste Msix-Bundle herunter 
# und installiert das neuste WinGet
# 

# !KH9^9 Windows Server
#
# cd C:\Temp
# Invoke-WebRequest -Uri https://aka.ms/Microsoft.VCLibs.x64.14.00.Desktop.appx -Method Get -OutFile Microsoft.VCLibs.x64.14.00.Desktop.appx
# Add-AppxPackage -Path .\Microsoft.VCLibs.x64.14.00.Desktop.appx
# Install-Script winget-install -Force
# winget-install -Force
 
# 

# 001, 250617, Tom
# 002, 250724, Tom


Param (
	# Prereleases werden auch heruntergeladen
	[Switch]$GetNewestPrerelease
)




# !9^9
# Holt für ein GitHub Projekt alle Releases
# und für jeden Release alle Assets
Function Get-Github-Releases {
    param (
        [String]$owner = 'microsoft',
        [String]$repo = 'winget-cli',
		[Switch]$Dbg
    )


	# GitHub API-URL
	$uri = "https://api.github.com/repos/$owner/$repo/releases?per_page=10"
	$uri = "https://api.github.com/repos/$owner/$repo/releases"

	# GitHub verlangt einen User-Agent-Header
	$headers = @{ 'User-Agent' = 'PowerShell' }

	# Abrufen der Releases
	$releases = Invoke-RestMethod -Uri $uri -Headers $headers

	$Rels = @()	
	foreach ($release in $releases) {
		If ($Dbg) {
			Write-Host "Release: $($release.name) ($($release.tag_name))" -ForegroundColor Cyan
			Write-Host "Veröffentlicht am: $($release.published_at)"
		}
		
		if ($release.assets.Count -eq 0) {
			If ($Dbg) {
				Write-Host '  Keine Assets vorhanden.' -ForegroundColor DarkGray
			}
		} else {
			foreach ($asset in $release.assets) {
				$Rels += [PSCustomObject]@{
					RelName = $release.name
					RelTag = $release.tag_name
					Name        = $asset.name
					UpdatedAt = [DateTime]$asset.updated_at
					Draft       = $release.draft
					Prerelease  = $release.prerelease
					SizeKB      = [math]::Round($asset.size / 1KB, 2)
					DownloadURL = $asset.browser_download_url
					ContentType = $asset.content_type
				}
			}
		}
		
		If ($Dbg) {	Write-Host '' }
	}

	# Neuster Rel. zuerst
	$Rels | Sort UpdatedAt -Descending
}


Function Is-Version-newer-than($V1, $V2) {
	
	# Von den Versions-Strings nur Zahlen und Punkte behalten
	$oV1 = [Version]($V1 -Replace '[^0-9.]', '')
	$oV2 = [Version]($V2 -Replace '[^0-9.]', '')
	
	# Ist V1 neuer als V2
	$IsNewer = $oV1 -gt $oV2
	Return $IsNewer
}


Function Download-and-Install-LatestWingetMsixbundle {
    Param (
        [String]$DownloadPath = 'C:\temp\',
        [Switch]$GetNewestPrerelease
    )
	
	# Welcher Rel ist installiert?
	$WinGetInfo = Get-Command WinGet -ErrorAction SilentlyContinue
	$HasWinGetInstalled = ($WinGetInfo -ne $Null)
	
	If ($HasWinGetInstalled) {
		$WingetInstalledRel = (winget --version).Trim()
	}
	
	
	# Alle Releases abrufen
	$Rels = Get-Github-Releases
	
	# Nur die msixbundle
	$MsixBundles = $Rels | ? Name -like '*.msixbundle'
	
	# Keine Prereleases?
	If (-not $GetNewestPrerelease) {
		# Die Prereleases entfernen
		$MsixBundles = $MsixBundles | ? Prerelease -eq $False
	}
	
	# Neuste Releases zuerst
	$NewestRel = $MsixBundles | Sort UpdatedAt -Descending | Select -First 1
	
	if (-not $NewestRel) {
        Write-Error 'Keine .msixbundle-Datei gefunden.'
		Return
    }
	
	If (-Not ($HasWinGetInstalled)) {
		$IsVersionTooOld = $True
		$IsInstalledVersionNewerThanNewest = $False
	} Else {
		$IsVersionTooOld = Is-Version-newer-than -V1 $NewestRel.RelTag `
											 -V2 $WingetInstalledRel
		
		$IsInstalledVersionNewerThanNewest = Is-Version-newer-than `
											-V1 $WingetInstalledRel `
											-V2 $NewestRel.RelTag
	}
	
	If ($IsVersionTooOld -eq $False) {
		Write-Host "Neuste Version bereits installiert: $WingetInstalledRel" -Fore Green
		Return
	}

	# Ist die installierte Version neuer?
	If ($IsInstalledVersionNewerThanNewest -gt $NewestRel.RelTag) {
		Write-Host "Die installierte Version ist neuer:" -Fore Yellow
		Write-Host "Installiert: $WingetInstalledRel"
		Write-Host "Verfügbar  : $($NewestRel.RelTag)"
		Write-Host "Tipp: -GetNewestPrerelease nützen!" -Fore Magenta
		Return
	}
	
	$Url = $NewestRel.DownloadURL
	
	# Zielpfad zusammenbauen
	# Write-Host "DownloadPath: $DownloadPath"
	# Write-Host "DownloadPath: $($NewestRel.Name)"
    $outFile = Join-Path $DownloadPath $NewestRel.Name
    
	# Herunterladen
    Invoke-WebRequest -Uri $Url -OutFile $outFile
	
	# Installieren
	Add-AppxPackage -Path $outFile
	
	# Löschen
	Start-Sleep -Milliseconds 2500
	Remove-Item -LiteralPath $outFile -Force	

}

Download-and-Install-LatestWingetMsixbundle -GetNewestPrerelease:$GetNewestPrerelease

